/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.utils.SchedulerUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TaskManager {
    public static TaskManager taskManager;
    private SchedulerUtil saveTask;

    public TaskManager() {
        taskManager = this;
        if (ConfigManager.configManager.getBoolean("auto-save.enabled")) {
            this.initSaveTasks();
        }
    }

    public void initSaveTasks() {
        this.saveTask = SchedulerUtil.runTaskTimer(() -> {
            if (!ConfigManager.configManager.getBoolean("auto-save.hide-message")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fAuto saving data...");
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fIf this lead to server TPS drop, you should consider disable auto save feature at config.yml!");
            }
            ServerCache.serverCache.shutServerCache(false);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (CacheManager.cacheManager.getPlayerCache(player) == null) continue;
                CacheManager.cacheManager.getPlayerCache(player).shutPlayerCache(false);
            }
        }, 180L, ConfigManager.configManager.config.getLong("auto-save.period-tick", 600L));
    }

    public void cancelTask() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
    }
}

