/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.methods;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.methods.Product.BuyProductMethod;
import cn.superiormc.ultimateshop.methods.Product.SellProductMethod;
import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItemStack;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.meta.ItemMeta;

public class ModifyDisplayItem {
    public static ObjectDisplayItemStack modifyItem(Player player, int multi, ObjectDisplayItemStack addLoreDisplayItem, ObjectItem item, boolean buyMore) {
        return ModifyDisplayItem.modifyItem(player, multi, addLoreDisplayItem, item, buyMore, "general");
    }

    public static ObjectDisplayItemStack modifyItem(Player player, int multi, ObjectDisplayItemStack addLoreDisplayItem, ObjectItem item, boolean buyMore, String clickType) {
        ItemMeta tempVal2;
        if (clickType == null) {
            clickType = "general";
        }
        if ((tempVal2 = addLoreDisplayItem.getMeta()) == null) {
            return addLoreDisplayItem;
        }
        if (item.getItemConfig().getString("display-name") != null) {
            UltimateShop.methodUtil.setItemName(tempVal2, item.getDisplayName(player), player);
        }
        if (tempVal2.hasDisplayName()) {
            UltimateShop.methodUtil.setItemName(tempVal2, CommonUtil.modifyString(UltimateShop.methodUtil.getItemName(tempVal2), "amount", String.valueOf(multi), "item-name", item.getDisplayName(player)), player);
        }
        ArrayList<String> addLore = new ArrayList<String>();
        if (tempVal2.hasLore()) {
            addLore.addAll(CommonUtil.modifyList(player, UltimateShop.methodUtil.getItemLore(tempVal2), "amount", String.valueOf(multi), "item-name", item.getDisplayName(player)));
        }
        addLore.addAll(ModifyDisplayItem.getModifiedLore(player, multi, item, buyMore, false, clickType));
        if (!addLore.isEmpty()) {
            UltimateShop.methodUtil.setItemLore(tempVal2, addLore, player);
        }
        addLoreDisplayItem.setItemMeta(tempVal2);
        return addLoreDisplayItem;
    }

    public static List<String> getModifiedLore(Player player, int multi, ObjectItem item, boolean buyMore, boolean bedrock, String clickType) {
        List<String> addLore = new ArrayList<String>();
        int buyTimes = 0;
        int sellTimes = 0;
        ObjectUseTimesCache tempVal9 = CacheManager.cacheManager.getPlayerCache(player).getUseTimesCache().get(item);
        ObjectUseTimesCache tempVal10 = CacheManager.cacheManager.serverCache.getUseTimesCache().get(item);
        if (tempVal9 != null) {
            buyTimes = tempVal9.getBuyUseTimes();
            sellTimes = tempVal9.getSellUseTimes();
        } else {
            tempVal9 = CacheManager.cacheManager.getPlayerCache(player).createUseTimesCache(item);
        }
        if (tempVal10 == null) {
            tempVal10 = CacheManager.cacheManager.serverCache.createUseTimesCache(item);
        }
        Iterator<String> iterator = item.getAddLore().iterator();
        while (iterator.hasNext()) {
            String tempVal3;
            String tempVal4 = tempVal3 = iterator.next();
            if (bedrock) {
                tempVal4 = TextUtil.parse(tempVal4);
            }
            boolean not = false;
            if (tempVal4.endsWith("-b")) {
                if (bedrock) continue;
                tempVal4 = tempVal4.substring(0, tempVal4.length() - 2);
            }
            if (tempVal4.endsWith("-m")) {
                if (!buyMore) continue;
                tempVal4 = tempVal4.substring(0, tempVal4.length() - 2);
            }
            if (tempVal4.endsWith("-i")) {
                not = true;
                tempVal4 = tempVal4.substring(0, tempVal4.length() - 2);
            }
            if (tempVal3.startsWith("@") && tempVal4.length() >= 2) {
                tempVal4 = tempVal4.substring(2);
                switch (tempVal3.charAt(1)) {
                    case 'a': {
                        if (!ModifyDisplayItem.parseClickType(item, clickType, true)) break;
                        if (!item.getBuyPrice().empty) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'b': {
                        if (!ModifyDisplayItem.parseClickType(item, clickType, false)) break;
                        if (!item.getSellPrice().empty) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'c': {
                        if (item.getPlayerBuyLimit(player) != -1) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'd': {
                        if (item.getServerBuyLimit(player) != -1) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'e': {
                        if (item.getPlayerSellLimit(player) != -1) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'f': {
                        if (item.getServerSellLimit(player) != -1) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'g': {
                        if (tempVal9 != null && item.getPlayerBuyLimit(player) > 0 && tempVal9.getBuyUseTimes() >= item.getPlayerBuyLimit(player)) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'h': {
                        if (tempVal9 != null && item.getPlayerSellLimit(player) > 0 && tempVal9.getSellUseTimes() >= item.getPlayerSellLimit(player)) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'i': {
                        if (tempVal10 != null && item.getServerBuyLimit(player) > 0 && tempVal10.getBuyUseTimes() >= item.getServerBuyLimit(player)) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'j': {
                        if (tempVal10 != null && item.getServerSellLimit(player) > 0 && tempVal10.getSellUseTimes() >= item.getServerSellLimit(player)) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'k': {
                        if (!buyMore && item.getBuyMore()) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'm': {
                        if (!ModifyDisplayItem.parseClickType(item, clickType, false)) break;
                        if (!item.getSellPrice().empty && item.isEnableSellAll()) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                        break;
                    }
                    case 'n': {
                        if (!item.getBuyPrice().empty && ModifyDisplayItem.parseClickType(item, clickType, true) || !item.getSellPrice().empty && ModifyDisplayItem.parseClickType(item, clickType, false)) {
                            if (not) break;
                            addLore.add(tempVal4);
                            break;
                        }
                        if (!not) break;
                        addLore.add(tempVal4);
                    }
                }
                continue;
            }
            addLore.add(tempVal3);
        }
        if (!addLore.isEmpty()) {
            if (tempVal9 != null && tempVal10 != null) {
                addLore = CommonUtil.modifyList(player, addLore, "buy-price", ObjectPrices.getDisplayNameInLine(player, multi, item.getBuyPrice().take((Inventory)player.getInventory(), player, tempVal9.getBuyUseTimes(), multi, true).getResultMap(), item.getBuyPrice().getMode(), false), "sell-price", ObjectPrices.getDisplayNameInLine(player, multi, item.getSellPrice().give(player, tempVal9.getBuyUseTimes(), multi).getResultMap(), item.getSellPrice().getMode(), false), "buy-limit-player", String.valueOf(item.getPlayerBuyLimit(player)), "sell-limit-player", String.valueOf(item.getPlayerSellLimit(player)), "buy-limit-server", String.valueOf(item.getServerBuyLimit(player)), "sell-limit-server", String.valueOf(item.getServerSellLimit(player)), "buy-total-player", String.valueOf(tempVal9.getTotalBuyUseTimes()), "sell-total-player", String.valueOf(tempVal9.getTotalSellUseTimes()), "buy-total-server", String.valueOf(tempVal10.getTotalBuyUseTimes()), "sell-total-server", String.valueOf(tempVal10.getTotalSellUseTimes()), "buy-times-player", String.valueOf(buyTimes), "sell-times-player", String.valueOf(sellTimes), "buy-refresh-player", String.valueOf(tempVal9.getBuyRefreshTimeDisplayName()), "sell-refresh-player", String.valueOf(tempVal9.getSellRefreshTimeDisplayName()), "buy-next-player", String.valueOf(tempVal9.getBuyRefreshTimeNextName()), "sell-next-player", String.valueOf(tempVal9.getSellRefreshTimeNextName()), "buy-times-server", String.valueOf(tempVal10.getBuyUseTimes()), "sell-times-server", String.valueOf(tempVal10.getSellUseTimes()), "buy-refresh-server", String.valueOf(tempVal10.getBuyRefreshTimeDisplayName()), "sell-refresh-server", String.valueOf(tempVal10.getSellRefreshTimeDisplayName()), "buy-next-server", String.valueOf(tempVal10.getBuyRefreshTimeNextName()), "sell-next-server", String.valueOf(tempVal10.getSellRefreshTimeNextName()), "last-buy-player", tempVal9.getBuyLastTimeName(), "last-sell-player", tempVal9.getSellLastTimeName(), "last-buy-server", tempVal10.getBuyLastTimeName(), "last-sell-server", tempVal10.getSellLastTimeName(), "last-reset-buy-player", tempVal9.getBuyLastResetTimeName(), "last-reset-sell-player", tempVal9.getSellLastResetTimeName(), "last-reset-buy-server", tempVal10.getBuyLastResetTimeName(), "last-reset-sell-server", tempVal10.getSellLastResetTimeName(), "buy-click", ModifyDisplayItem.getBuyClickPlaceholder(player, multi, item, clickType), "sell-click", ModifyDisplayItem.getSellClickPlaceholder(player, multi, item, clickType), "amount", String.valueOf(multi), "item-name", item.getDisplayName(player));
            } else if (player.getOpenInventory().getType() == InventoryType.CHEST) {
                player.closeInventory();
                LanguageManager.languageManager.sendStringText(player, "plugin.reload-close-gui");
            }
        }
        return addLore;
    }

    private static String getBuyClickPlaceholder(Player player, int multi, ObjectItem item, String clickType) {
        if (!ConfigManager.configManager.getBoolean("placeholder.click.enabled")) {
            if (item.getSellPrice().empty || clickType.equals("buy")) {
                return ConfigManager.configManager.getString("placeholder.click.buy-with-no-sell", "", "amount", String.valueOf(multi));
            }
            return ConfigManager.configManager.getString("placeholder.click.buy", "", "amount", String.valueOf(multi));
        }
        String s = "";
        switch (BuyProductMethod.startBuy(item, player, false, true, multi).getStatus()) {
            case ERROR: {
                s = ConfigManager.configManager.getString("placeholder.click.error", "", "amount", String.valueOf(multi));
                break;
            }
            case PERMISSION: {
                s = ConfigManager.configManager.getString("placeholder.click.buy-condition-not-meet", "", "amount", String.valueOf(multi));
                break;
            }
            case PLAYER_MAX: {
                s = ConfigManager.configManager.getString("placeholder.click.buy-max-limit-player", "", "amount", String.valueOf(multi));
                break;
            }
            case SERVER_MAX: {
                s = ConfigManager.configManager.getString("placeholder.click.buy-max-limit-server", "", "amount", String.valueOf(multi));
                break;
            }
            case NOT_ENOUGH: {
                s = ConfigManager.configManager.getString("placeholder.click.buy-price-not-enough", "", "amount", String.valueOf(multi));
                break;
            }
            case DONE: {
                s = item.getSellPrice().empty || clickType.equals("buy") ? ConfigManager.configManager.getString("placeholder.click.buy-with-no-sell", "", "amount", String.valueOf(multi)) : ConfigManager.configManager.getString("placeholder.click.buy", "", "amount", String.valueOf(multi));
            }
        }
        return s;
    }

    private static String getSellClickPlaceholder(Player player, int multi, ObjectItem item, String clickType) {
        if (!ConfigManager.configManager.getBoolean("placeholder.click.enabled")) {
            if (item.getBuyPrice().empty || clickType.equals("sell")) {
                return ConfigManager.configManager.getString("placeholder.click.sell-with-no-buy", "", "amount", String.valueOf(multi));
            }
            return ConfigManager.configManager.getString("placeholder.click.sell", "", "amount", String.valueOf(multi));
        }
        return switch (SellProductMethod.startSell(item, player, false, true, multi).getStatus()) {
            case ProductTradeStatus.Status.ERROR -> ConfigManager.configManager.getString("placeholder.click.error", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.PERMISSION -> ConfigManager.configManager.getString("placeholder.click.sell-condition-not-meet", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.PLAYER_MAX -> ConfigManager.configManager.getString("placeholder.click.sell-max-limit-player", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.SERVER_MAX -> ConfigManager.configManager.getString("placeholder.click.sell-max-limit-server", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.NOT_ENOUGH -> ConfigManager.configManager.getString("placeholder.click.sell-price-not-enough", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.DONE -> {
                if (item.getBuyPrice().empty || clickType.equals("sell")) {
                    yield ConfigManager.configManager.getString("placeholder.click.sell-with-no-buy", "", "amount", String.valueOf(multi));
                }
                yield ConfigManager.configManager.getString("placeholder.click.sell", "", "amount", String.valueOf(multi));
            }
            default -> "Unknown";
        };
    }

    private static boolean parseClickType(ObjectItem item, String clickType, boolean buyOrSell) {
        if (clickType == null || clickType.equals("general")) {
            return true;
        }
        switch (clickType) {
            case "buy": {
                return buyOrSell;
            }
            case "sell": {
                return !buyOrSell;
            }
            case "sell-all": {
                return !buyOrSell && item.isEnableSellAll();
            }
            case "buy-or-sell": {
                if (item.getBuyPrice().empty && !item.getSellPrice().empty) {
                    return !buyOrSell;
                }
                return buyOrSell;
            }
        }
        return false;
    }
}

