/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects;

import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public abstract class AbstractSingleRun {
    protected ConfigurationSection section;
    protected int startApply;
    protected int endApply;
    protected List<Integer> apply;
    protected boolean multiOnce;
    protected boolean sellAllOnce;
    protected boolean openOnce;
    protected String clickType;
    private ObjectShop shop;
    private ObjectItem item;

    public AbstractSingleRun(ConfigurationSection section) {
        this.section = section;
        this.startApply = section.getInt("start-apply", -1);
        this.endApply = section.getInt("end-apply", -1);
        this.apply = section.getIntegerList("apply");
        this.multiOnce = section.getBoolean("multi-once", false);
        this.sellAllOnce = section.getBoolean("sell-all-once", false);
        this.openOnce = section.getBoolean("open-once", false);
        this.clickType = section.getString("click-type", null);
    }

    public AbstractSingleRun(ConfigurationSection section, ObjectItem item) {
        this.section = section;
        this.item = item;
        this.shop = item.getShopObject();
        this.startApply = section.getInt("start-apply", -1);
        this.endApply = section.getInt("end-apply", -1);
        this.apply = section.getIntegerList("apply");
        this.multiOnce = section.getBoolean("multi-once", false);
        this.sellAllOnce = section.getBoolean("sell-all-once", false);
        this.openOnce = section.getBoolean("open-once", false);
        this.clickType = section.getString("click-type", null);
    }

    public AbstractSingleRun(ConfigurationSection section, ObjectShop shop) {
        this.section = section;
        this.shop = shop;
        this.startApply = section.getInt("start-apply", -1);
        this.endApply = section.getInt("end-apply", -1);
        this.apply = section.getIntegerList("apply");
        this.multiOnce = section.getBoolean("multi-once", false);
        this.sellAllOnce = section.getBoolean("sell-all-once", false);
        this.openOnce = section.getBoolean("open-once", false);
        this.clickType = section.getString("click-type", null);
    }

    protected String replacePlaceholder(String content, Player player, double amount) {
        content = CommonUtil.modifyString(content, "world", player.getWorld().getName(), "amount", String.valueOf(amount), "player_x", String.valueOf(player.getLocation().getX()), "player_y", String.valueOf(player.getLocation().getY()), "player_z", String.valueOf(player.getLocation().getZ()), "player_pitch", String.valueOf(player.getLocation().getPitch()), "player_yaw", String.valueOf(player.getLocation().getYaw()), "player", player.getName());
        content = TextUtil.withPAPI(content, player);
        if (this.shop != null) {
            content = CommonUtil.modifyString(content, "shop-menu", this.shop.getShopMenu(), "shop", this.shop.getShopName(), "shop-name", this.shop.getShopDisplayName());
        }
        if (this.item != null) {
            content = CommonUtil.modifyString(content, "item", this.item.getProduct(), "item-name", this.item.getDisplayName(player));
        }
        return content;
    }

    public String getString(String path) {
        return this.section.getString(path);
    }

    public List<String> getStringList(String path) {
        return this.section.getStringList(path);
    }

    public int getInt(String path) {
        return this.section.getInt(path);
    }

    public int getInt(String path, int defaultValue) {
        return this.section.getInt(path, defaultValue);
    }

    public double getDouble(String path) {
        return this.section.getDouble(path);
    }

    public double getDouble(String path, Player player, double amount) {
        return Double.parseDouble(this.replacePlaceholder(this.section.getString(path), player, amount));
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.section.getBoolean(path, defaultValue);
    }

    public boolean contains(String path) {
        return this.section.contains(path);
    }

    public ConfigurationSection getSection(String path) {
        return this.section.getConfigurationSection(path);
    }

    public String getString(String path, Player player, double amount) {
        return this.replacePlaceholder(this.section.getString(path), player, amount);
    }

    public ConfigurationSection getSection() {
        return this.section;
    }
}

