/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.methods.Items.BuildItem;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ObjectSellStick {
    public static final NamespacedKey SELL_STICK_TIMES = new NamespacedKey((Plugin)UltimateShop.instance, "sell_stick_usage");
    public static final NamespacedKey SELL_STICK_ID = new NamespacedKey((Plugin)UltimateShop.instance, "sell_stick_id");
    private final String id;
    private final ConfigurationSection section;
    private final ObjectAction action;
    private final ObjectCondition condition;
    private final int usageTimes;
    private final boolean infinite;
    private final double multiplier;

    public ObjectSellStick(String id, ConfigurationSection section) {
        this.id = id;
        this.section = section;
        this.action = new ObjectAction(section.getConfigurationSection("actions"));
        this.condition = new ObjectCondition(section.getConfigurationSection("conditions"));
        this.usageTimes = section.getInt("usage-times");
        this.multiplier = section.getDouble("multiplier");
        this.infinite = this.usageTimes < 0 || section.getBoolean("infinite");
        UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded sell stick: " + id + ".yml!");
    }

    public String getID() {
        return this.id;
    }

    public ItemStack getNewItem(Player player, int amount) {
        return this.getItemWithUsageTimes(player, amount, this.usageTimes);
    }

    public ItemStack getItemWithUsageTimes(Player player, int amount, int times) {
        ItemStack resultItem = this.section.contains("display-item") ? BuildItem.buildItemStack(player, this.section.getConfigurationSection("display-item"), 1, new String[0]) : BuildItem.buildItemStack(player, this.section, 1, new String[0]);
        resultItem.setAmount(amount);
        if (!resultItem.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = resultItem.getItemMeta();
        ArrayList<String> newLore = new ArrayList<String>();
        if (meta.hasLore()) {
            for (String str : UltimateShop.methodUtil.getItemLore(meta)) {
                str = !this.infinite ? CommonUtil.modifyString(str, "times", String.valueOf(times)) : CommonUtil.modifyString(str, "times", ConfigManager.configManager.getString("placeholder.sell-stick.infinite", new String[0]));
                newLore.add(str);
            }
            UltimateShop.methodUtil.setItemLore(meta, newLore, player);
        }
        meta.getPersistentDataContainer().remove(SELL_STICK_ID);
        meta.getPersistentDataContainer().remove(SELL_STICK_TIMES);
        meta.getPersistentDataContainer().set(SELL_STICK_ID, PersistentDataType.STRING, (Object)this.id);
        if (!this.infinite) {
            meta.getPersistentDataContainer().set(SELL_STICK_TIMES, PersistentDataType.INTEGER, (Object)times);
        }
        resultItem.setItemMeta(meta);
        return resultItem;
    }

    public void takeUsageTimes(Player player, ItemStack item) {
        ItemStack tempItem;
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            return;
        }
        if (this.infinite) {
            return;
        }
        int nowValue = ObjectSellStick.getSellStickValue(item);
        item.setAmount(item.getAmount() - 1);
        if (nowValue - 1 > 0 && (tempItem = this.getItemWithUsageTimes(player, 1, nowValue - 1)) != null) {
            CommonUtil.giveOrDrop(player, tempItem);
        }
    }

    public static int getSellStickValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (!item.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.getPersistentDataContainer().has(SELL_STICK_TIMES, PersistentDataType.INTEGER)) {
            return 0;
        }
        return (Integer)meta.getPersistentDataContainer().get(SELL_STICK_TIMES, PersistentDataType.INTEGER);
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public ObjectCondition getCondition() {
        return this.condition;
    }

    public ObjectAction getAction() {
        return this.action;
    }
}

