/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.inv.ShopGUI;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectCopyItem;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.CommandUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class ObjectShop {
    private final YamlConfiguration config;
    private final Map<String, ObjectItem> items = new HashMap<String, ObjectItem>();
    private final Map<String, ObjectCopyItem> copyItems = new HashMap<String, ObjectCopyItem>();
    public Map<String, AbstractButton> buttonItems = new HashMap<String, AbstractButton>();
    private final String shopName;
    private ObjectMenu menu;

    public ObjectShop(String fileName, YamlConfiguration config) {
        this.shopName = fileName;
        this.config = config;
        this.initProducts();
        this.initButtonItems();
    }

    private void initProducts() {
        if (this.config.getConfigurationSection("items") == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not get items section in your shop config!!");
            return;
        }
        for (String s : this.config.getConfigurationSection("items").getKeys(false)) {
            ConfigurationSection itemSection = this.config.getConfigurationSection("items." + s);
            if (itemSection == null) continue;
            String tempVal1 = itemSection.getString("as-sub-button");
            if (tempVal1 != null) {
                this.copyItems.put(s, null);
                continue;
            }
            this.items.put(s, new ObjectItem(this, itemSection));
        }
    }

    public void initCopyProducts() {
        for (String s : this.copyItems.keySet()) {
            String tempVal1;
            if (this.items.containsKey(s)) {
                this.copyItems.remove(s);
                continue;
            }
            ConfigurationSection itemSection = this.config.getConfigurationSection("items." + s);
            if (itemSection == null || (tempVal1 = itemSection.getString("as-sub-button")) == null) continue;
            String[] tempVal2 = tempVal1.split(";;");
            if (tempVal2.length >= 2) {
                ObjectItem item;
                ObjectShop shop = ConfigManager.configManager.getShop(tempVal2[0]);
                if (shop == null || (item = shop.getProduct(tempVal2[1])) == null) continue;
                this.items.put(s, item);
                this.copyItems.put(s, new ObjectCopyItem(itemSection, item));
                continue;
            }
            ObjectItem item = this.items.get(tempVal1);
            if (item == null) continue;
            this.items.put(s, item);
            this.copyItems.put(s, new ObjectCopyItem(itemSection, item));
        }
    }

    public void initMenus() {
        if (this.config.getString("settings.menu") != null) {
            this.menu = new ObjectMenu(this.config.getString("settings.menu"), this);
        }
    }

    private void initButtonItems() {
        ConfigurationSection tempVal1 = this.config.getConfigurationSection("buttons");
        if (tempVal1 == null) {
            return;
        }
        for (String button : tempVal1.getKeys(false)) {
            this.buttonItems.put(button, new ObjectButton(tempVal1.getConfigurationSection(button), this));
        }
    }

    private void initCustomCommand() {
        String commandName = this.config.getString("settings.custom-command.name");
        if (commandName != null && !commandName.isEmpty()) {
            final ObjectShop shop = this;
            BukkitCommand command = new BukkitCommand(commandName){

                public boolean execute(CommandSender sender, String label, String[] args) {
                    if (!(sender instanceof Player)) {
                        LanguageManager.languageManager.sendStringText("error.in-game");
                        return true;
                    }
                    ShopGUI.openGUI((Player)sender, shop, false, false);
                    return true;
                }
            };
            command.setDescription(this.config.getString("settings.custom-command.description", "UltimateShop Custom Command for " + commandName));
            CommandUtil.registerCustomCommand(command);
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fRegistered custom command for shop: " + this.shopName + ".");
        }
    }

    public YamlConfiguration getShopConfig() {
        return this.config;
    }

    public AbstractButton getButton(String buttonID) {
        if (buttonID == null) {
            return null;
        }
        return this.buttonItems.get(buttonID);
    }

    public ObjectItem getProduct(String productID) {
        if (productID == null) {
            return null;
        }
        return this.items.get(productID);
    }

    public ObjectItem getProductNotHidden(String productID) {
        if (productID == null) {
            return null;
        }
        ObjectItem item = this.items.get(productID);
        if (this.menu != null && !this.menu.menuItems.containsValue(item) && ConfigManager.configManager.getBoolean("menu.secret-shop-items")) {
            return null;
        }
        return item;
    }

    public ObjectCopyItem getCopyItem(String itemID) {
        if (itemID == null) {
            return null;
        }
        return this.copyItems.get(itemID);
    }

    public List<ObjectItem> getProductList() {
        ArrayList<ObjectItem> resultItems = new ArrayList<ObjectItem>();
        for (String key : this.items.keySet()) {
            ObjectItem item = this.items.get(key);
            resultItems.add(item);
        }
        return resultItems;
    }

    public List<ObjectItem> getProductListNotHidden() {
        ArrayList<ObjectItem> resultItems = new ArrayList<ObjectItem>();
        for (String key : this.items.keySet()) {
            ObjectItem item = this.items.get(key);
            if (this.menu != null && !this.menu.menuItems.containsValue(item) && ConfigManager.configManager.getBoolean("menu.secret-shop-items")) continue;
            resultItems.add(item);
        }
        return resultItems;
    }

    public String getShopName() {
        return this.shopName;
    }

    public String getShopMenu() {
        if (this.menu == null) {
            return "";
        }
        return this.menu.getName();
    }

    @Nullable
    public ObjectMenu getShopMenuObject() {
        return this.menu;
    }

    public String getShopDisplayName() {
        return this.config.getString("settings.shop-name", this.menu == null ? "" : this.menu.getName());
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public String toString() {
        return this.getShopName();
    }
}

