/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.actions;

import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.actions.ObjectSingleAction;

public abstract class AbstractRunAction {
    private final String type;
    private String[] requiredArgs;

    public AbstractRunAction(String type) {
        this.type = type;
    }

    protected void setRequiredArgs(String ... requiredArgs) {
        this.requiredArgs = requiredArgs;
    }

    public void runAction(ObjectSingleAction singleAction, ObjectThingRun thingRun) {
        if (this.requiredArgs != null) {
            for (String arg : this.requiredArgs) {
                if (singleAction.getSection().contains(arg)) continue;
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your action missing required arg: " + arg + ".");
                return;
            }
        }
        this.onDoAction(singleAction, thingRun);
    }

    protected abstract void onDoAction(ObjectSingleAction var1, ObjectThingRun var2);

    public String getType() {
        return this.type;
    }
}

