/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons;

import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ButtonType;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItem;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItemStack;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class ObjectButton
extends AbstractButton {
    private ObjectShop shop;
    private ObjectAction action;
    private ObjectAction failAction;
    private ObjectCondition condition;
    private ObjectDisplayItem displayItem;

    public ObjectButton(ConfigurationSection config) {
        super(config);
        this.type = ButtonType.COMMON;
        if (config == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not found config for button, there is something wrong in your menu configs!");
            return;
        }
        this.initButton();
    }

    public ObjectButton(ConfigurationSection config, ObjectShop shop) {
        super(config);
        this.type = ButtonType.COMMON;
        this.shop = shop;
        if (config == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not found config for button, there is something wrong in your menu configs!");
            return;
        }
        this.initButton();
    }

    private void initButton() {
        if (this.shop == null) {
            this.action = new ObjectAction(this.config.getConfigurationSection("actions"));
            this.failAction = new ObjectAction(this.config.getConfigurationSection("fail-actions"));
        } else {
            this.action = new ObjectAction(this.config.getConfigurationSection("actions"), this.shop);
            this.failAction = new ObjectAction(this.config.getConfigurationSection("fail-actions"), this.shop);
        }
        this.condition = new ObjectCondition(this.config.getConfigurationSection("conditions"));
        this.displayItem = new ObjectDisplayItem(this.config.getConfigurationSection("display-item"), this.config.getConfigurationSection(ConfigManager.configManager.getString("conditions.display-item-key", new String[0])));
    }

    @Override
    public void clickEvent(ClickType type, Player player) {
        if (this.condition != null && !this.condition.getAllBoolean(new ObjectThingRun(player, type))) {
            this.failAction.runAllActions(new ObjectThingRun(player, type));
            return;
        }
        if (this.action != null) {
            this.action.runAllActions(new ObjectThingRun(player, type));
        }
    }

    @Override
    public ObjectDisplayItemStack getDisplayItem(Player player, int unUsed) {
        if (this.displayItem == null) {
            return ObjectDisplayItemStack.getAir();
        }
        return this.displayItem.getDisplayItem(player);
    }
}

