/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons.subobjects;

import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.methods.Items.BuildItem;
import cn.superiormc.ultimateshop.methods.ModifyDisplayItem;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItemStack;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.objects.items.products.ObjectSingleProduct;
import cn.superiormc.ultimateshop.utils.MathUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ObjectDisplayItem {
    private final ConfigurationSection section;
    private ConfigurationSection usedSection;
    private boolean useFirstProduct = false;
    private final ConfigurationSection conditionSection;
    private ObjectItem item;

    public ObjectDisplayItem(ConfigurationSection section, ConfigurationSection conditionSection, ObjectItem item) {
        if (section == null) {
            this.useFirstProduct = true;
            this.section = item.getItemConfig();
        } else {
            this.section = section;
        }
        this.conditionSection = conditionSection;
        this.item = item;
    }

    public ObjectDisplayItem(ConfigurationSection section, ConfigurationSection conditionSection) {
        this.section = section;
        this.conditionSection = conditionSection;
    }

    public ObjectDisplayItemStack getDisplayItem(Player player) {
        ItemStack addLoreDisplayItem;
        block9: {
            block8: {
                addLoreDisplayItem = null;
                if (!this.useFirstProduct) break block8;
                if (this.item == null || !ConfigManager.configManager.getBoolean("display-item.auto-set-first-product")) break block9;
                ObjectSingleProduct singleProduct = this.item.getReward().getTargetProduct(player);
                if (singleProduct == null) {
                    return ObjectDisplayItemStack.getAir();
                }
                double cost = singleProduct.getAmount(player, 0, true).doubleValue();
                ItemStack tempVal2 = singleProduct.getItemThing(null, player, cost, true).getDisplayItem();
                if (tempVal2 != null) {
                    addLoreDisplayItem = tempVal2;
                    if (!this.section.contains("bedrock")) {
                        this.usedSection = singleProduct.singleSection;
                    }
                }
                break block9;
            }
            if (this.conditionSection == null) {
                String amount = this.section.getString("amount", "1");
                ItemStack displayItem = BuildItem.buildItemStack(player, this.section, MathUtil.doCalculate(TextUtil.withPAPI(amount, player)).intValue(), new String[0]);
                addLoreDisplayItem = displayItem.clone();
            } else {
                for (String conditionID : this.section.getKeys(false)) {
                    ObjectCondition condition;
                    ConfigurationSection tempVal1 = this.conditionSection.getConfigurationSection(conditionID);
                    if (tempVal1 == null || !(condition = new ObjectCondition(tempVal1)).getAllBoolean(new ObjectThingRun(player))) continue;
                    String amount = this.section.getString("amount", "1");
                    ItemStack displayItem = BuildItem.buildItemStack(player, this.section.getConfigurationSection(conditionID), MathUtil.doCalculate(TextUtil.withPAPI(amount, player)).intValue(), new String[0]);
                    addLoreDisplayItem = displayItem.clone();
                    this.usedSection = this.section.getConfigurationSection(conditionID);
                    break;
                }
            }
        }
        if (addLoreDisplayItem == null) {
            return ObjectDisplayItemStack.getAir();
        }
        if (this.usedSection == null) {
            this.usedSection = this.section;
        }
        ObjectDisplayItemStack displayItemStack = new ObjectDisplayItemStack(player, addLoreDisplayItem, this.usedSection, this.item);
        return displayItemStack;
    }

    public int getAmountPlaceholder(Player player) {
        if (!ConfigManager.configManager.getBoolean("display-item.calculate-amount")) {
            return 1;
        }
        return this.getDisplayItem(player).getItemStack().getAmount();
    }

    public ObjectDisplayItemStack getDisplayItem(Player player, int multi) {
        ObjectDisplayItemStack addLoreDisplayItem = this.getDisplayItem(player);
        if (this.item != null) {
            if (this.section != null && !this.section.getBoolean("modify-lore", true)) {
                return addLoreDisplayItem;
            }
            return ModifyDisplayItem.modifyItem(player, multi, addLoreDisplayItem, this.item, false);
        }
        return addLoreDisplayItem;
    }
}

