/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons.subobjects;

import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.ItemUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.util.FormImage;
import org.jetbrains.annotations.Nullable;

public class ObjectDisplayItemStack {
    private final ItemStack javaItem;
    private final ItemMeta meta;
    private ConfigurationSection section;
    private Player player;
    private ObjectItem item;

    public static ObjectDisplayItemStack getAir() {
        return new ObjectDisplayItemStack(new ItemStack(Material.AIR));
    }

    public ObjectDisplayItemStack(ItemStack javaItemOnly) {
        this.javaItem = javaItemOnly;
        this.meta = javaItemOnly.getItemMeta();
    }

    public ObjectDisplayItemStack(Player player, ItemStack javaItem, ConfigurationSection section, ObjectItem item) {
        this.javaItem = javaItem;
        this.meta = javaItem.getItemMeta();
        this.section = section;
        this.player = player;
        this.item = item;
    }

    public ItemMeta getMeta() {
        return this.meta;
    }

    public void setItemMeta(@Nullable ItemMeta itemMeta) {
        this.javaItem.setItemMeta(itemMeta);
    }

    public ButtonComponent parseToBedrockButton() {
        if (this.section == null) {
            return null;
        }
        String icon = this.section.getString("bedrock.icon", this.section.getString("bedrock-icon"));
        if (ItemUtil.getItemNameWithoutVanilla(this.javaItem).trim().isEmpty() || this.section.getBoolean("bedrock.hide", false)) {
            return null;
        }
        Object tempVal3 = TextUtil.parse(ItemUtil.getItemName(this.javaItem), this.player);
        String tempVal4 = this.section.getString("bedrock.extra-line");
        if (this.item == null) {
            if (tempVal4 != null && !tempVal4.isEmpty()) {
                tempVal3 = (String)tempVal3 + "\n" + TextUtil.parse(this.player, tempVal4);
            }
        } else {
            if (tempVal4 == null) {
                if (this.item.getBuyPrice().empty) {
                    if (!this.item.getSellPrice().empty) {
                        tempVal4 = ConfigManager.configManager.getString("menu.bedrock.price-extra-line.only-sell", "");
                    }
                } else {
                    tempVal4 = this.item.getSellPrice().empty ? ConfigManager.configManager.getString("menu.bedrock.price-extra-line.only-buy", "") : ConfigManager.configManager.getString("menu.bedrock.price-extra-line.default", "");
                }
            }
            if (tempVal4 != null && !tempVal4.isEmpty()) {
                ObjectUseTimesCache tempVal9 = CacheManager.cacheManager.getPlayerCache(this.player).getUseTimesCache().get(this.item);
                tempVal3 = (String)tempVal3 + "\n" + TextUtil.parse(this.player, CommonUtil.modifyString(tempVal4, "buy-price", ObjectPrices.getDisplayNameInLine(this.player, 1, this.item.getBuyPrice().take((Inventory)this.player.getInventory(), this.player, tempVal9.getBuyUseTimes(), 1, true).getResultMap(), this.item.getBuyPrice().getMode(), false), "sell-price", ObjectPrices.getDisplayNameInLine(this.player, 1, this.item.getSellPrice().give(this.player, tempVal9.getBuyUseTimes(), 1).getResultMap(), this.item.getSellPrice().getMode(), false)));
            }
        }
        ButtonComponent tempVal1 = null;
        if (icon != null && icon.split(";;").length == 2) {
            String type = icon.split(";;")[0].toLowerCase();
            if (type.equals("url")) {
                tempVal1 = ButtonComponent.of((String)tempVal3, (FormImage.Type)FormImage.Type.URL, (String)icon.split(";;")[1]);
            } else if (type.equals("path")) {
                tempVal1 = ButtonComponent.of((String)tempVal3, (FormImage.Type)FormImage.Type.PATH, (String)icon.split(";;")[1]);
            }
        } else {
            tempVal1 = ButtonComponent.of((String)tempVal3);
        }
        return tempVal1;
    }

    public ItemStack getItemStack() {
        if (this.javaItem == null) {
            return new ItemStack(Material.AIR);
        }
        return this.javaItem;
    }
}

