/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons.subobjects;

import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ObjectItemConfig {
    private final ObjectItem item;
    private final ConfigurationSection section;
    private final ConfigurationSection shopSection;
    public Map<String, ConfigurationSection> mergeCache;

    public ObjectItemConfig(ObjectItem objectItem, ConfigurationSection section) {
        this.item = objectItem;
        this.section = section;
        this.shopSection = objectItem.getShopObject().getShopConfig().getConfigurationSection("general-configs");
    }

    public ConfigurationSection getConfigurationSection(String key) {
        if (this.shopSection == null) {
            return this.section.getConfigurationSection(key);
        }
        ConfigurationSection tempVal1 = this.section.getConfigurationSection(key);
        if (tempVal1 == null) {
            return this.shopSection.getConfigurationSection(key);
        }
        return tempVal1;
    }

    public String getString(String key) {
        if (this.shopSection == null) {
            return this.section.getString(key);
        }
        String tempVal1 = this.section.getString(key);
        if (tempVal1 == null) {
            return this.shopSection.getString(key);
        }
        return tempVal1;
    }

    public String getString(String key, String defaultValue) {
        if (this.shopSection == null) {
            return this.section.getString(key, defaultValue);
        }
        String tempVal1 = this.section.getString(key);
        if (tempVal1 == null) {
            return this.shopSection.getString(key, defaultValue);
        }
        return tempVal1;
    }

    public List<String> getStringList(String path) {
        if (this.shopSection == null) {
            return this.section.getStringList(path);
        }
        List tempVal1 = this.section.getStringList(path);
        if (tempVal1.isEmpty()) {
            return this.shopSection.getStringList(path);
        }
        return tempVal1;
    }

    public ConfigurationSection getActionOrConditionSection(String path) {
        ConfigurationSection tempVal1 = this.section.getConfigurationSection(path);
        if (this.shopSection == null) {
            return tempVal1;
        }
        ConfigurationSection tempVal2 = this.shopSection.getConfigurationSection(path);
        if (tempVal1 != null) {
            if (tempVal2 == null) {
                return tempVal1;
            }
            if (this.mergeCache.containsKey(path)) {
                return this.mergeCache.get(path);
            }
            for (String key : tempVal1.getKeys(true)) {
                tempVal2.set(key, tempVal1.get(key));
            }
            this.mergeCache.put(path, tempVal2);
        }
        return tempVal2;
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        if (this.shopSection == null) {
            return this.section.getBoolean(path, defaultValue);
        }
        if (this.section.contains(path)) {
            return this.section.getBoolean(path);
        }
        return this.shopSection.getBoolean(path, defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        if (this.shopSection == null) {
            return this.section.getInt(path, defaultValue);
        }
        if (this.section.contains(path)) {
            return this.section.getInt(path);
        }
        return this.shopSection.getInt(path, defaultValue);
    }

    public int getIntWithPAPI(Player player, String path, String defaultValue) {
        if (this.shopSection == null) {
            return Integer.parseInt(TextUtil.withPAPI(this.section.getString(path, defaultValue), player));
        }
        if (this.section.contains(path)) {
            return Integer.parseInt(TextUtil.withPAPI(this.section.getString(path), player));
        }
        return Integer.parseInt(TextUtil.withPAPI(this.shopSection.getString(path, defaultValue), player));
    }

    public ConfigurationSection getSection() {
        return this.section;
    }

    public ObjectItem getItem() {
        return this.item;
    }

    public Set<String> getKeys(boolean deep) {
        return this.section.getKeys(deep);
    }
}

