/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.caches;

import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.BungeeCordManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectRandomPlaceholder;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

public class ObjectRandomPlaceholderCache {
    private List<String> nowValue = null;
    private LocalDateTime refreshDoneTime = null;
    private final ObjectRandomPlaceholder placeholder;
    private final ServerCache cache;

    public ObjectRandomPlaceholderCache(ServerCache cache, ObjectRandomPlaceholder placeholder) {
        this.cache = cache;
        this.placeholder = placeholder;
        this.setRefreshTime();
    }

    public ObjectRandomPlaceholderCache(ServerCache cache, ObjectRandomPlaceholder placeholder, List<String> nowValue, LocalDateTime refreshDoneTime) {
        this.cache = cache;
        this.placeholder = placeholder;
        this.nowValue = nowValue;
        this.refreshDoneTime = refreshDoneTime;
    }

    public ObjectRandomPlaceholder getPlaceholder() {
        return this.placeholder;
    }

    public LocalDateTime getRefreshDoneTime() {
        if (this.refreshDoneTime != null && !this.refreshDoneTime.isAfter(LocalDateTime.now())) {
            this.setRefreshTime();
        }
        return this.refreshDoneTime;
    }

    public void removeRefreshDoneTime() {
        this.refreshDoneTime = null;
    }

    public List<String> getNowValue() {
        return this.getNowValue(true, false);
    }

    public List<String> getNowValue(boolean disable) {
        return this.getNowValue(true, disable);
    }

    public List<String> getNowValue(boolean needRefresh, boolean disable) {
        if (needRefresh) {
            this.setRefreshTime(disable);
        }
        return this.nowValue;
    }

    public void setRefreshTime() {
        this.setRefreshTime(false);
    }

    public void setRefreshTime(boolean notUseBungee) {
        String mode = this.placeholder.getMode();
        String time = TextUtil.withPAPI(this.placeholder.getConfig().getString("reset-time"), null);
        if (mode == null || time.isEmpty()) {
            if (this.nowValue == null) {
                this.setPlaceholder(notUseBungee);
            }
            return;
        }
        if (mode.equals("ONCE")) {
            this.setPlaceholder(notUseBungee);
            return;
        }
        boolean needRefresh = this.nowValue == null || this.refreshDoneTime == null || !this.refreshDoneTime.isAfter(LocalDateTime.now());
        for (ObjectRandomPlaceholder tempVal1 : this.placeholder.getNotSameAs()) {
            if (tempVal1.equals(this.getPlaceholder()) || !tempVal1.getNowValue(this.cache).equals(this.nowValue)) continue;
            needRefresh = true;
        }
        if (needRefresh) {
            switch (mode) {
                case "TIMED": {
                    this.refreshDoneTime = this.getTimedRefreshTime(time);
                    break;
                }
                case "TIMER": {
                    this.refreshDoneTime = this.getTimerRefreshTime(time);
                    break;
                }
                case "CUSTOM": {
                    this.refreshDoneTime = CommonUtil.stringToTime(time, this.placeholder.getConfig().getString("time-format", "yyyy-MM-dd HH:mm:ss"));
                    break;
                }
                case "RANDOM_PLACEHOLDER": {
                    if (time.equals(this.placeholder.getID())) {
                        this.refreshDoneTime = LocalDateTime.now().withYear(2999);
                        break;
                    }
                    this.refreshDoneTime = ObjectRandomPlaceholder.getRefreshDoneTimeObject(this.cache.player, time);
                    break;
                }
                default: {
                    this.refreshDoneTime = LocalDateTime.now().withYear(2999);
                }
            }
            this.setPlaceholder(notUseBungee);
        }
    }

    public void setPlaceholder(boolean notUseBungee) {
        this.setPlaceholder(this.placeholder.getNewValue(this.cache), notUseBungee);
    }

    public void setPlaceholder(List<String> element, boolean notUseBungee) {
        if (element == null) {
            return;
        }
        this.nowValue = element;
        if (!this.placeholder.getMode().equals("ONCE") && this.refreshDoneTime != null) {
            this.cache.setRandomPlaceholderCache(this.placeholder, CommonUtil.timeToString(this.refreshDoneTime), this.nowValue);
        }
        if (!notUseBungee && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.placeholder.getID(), CommonUtil.translateStringList(this.nowValue), CommonUtil.timeToString(this.refreshDoneTime));
        }
    }

    private LocalDateTime getTimedRefreshTime(String time) {
        String[] tempVal3;
        LocalDate nowTime = LocalDate.now();
        LocalDateTime refreshResult = null;
        for (String tempVal4 : tempVal3 = time.split(";;")) {
            String[] tempVal2 = tempVal4.split(":");
            if (tempVal2.length < 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + tempVal4 + " is invalid.");
                return LocalDateTime.now();
            }
            int month = 0;
            int day = 0;
            if (tempVal2.length == 5) {
                month = Integer.parseInt(tempVal2[0]);
            }
            if (tempVal2.length >= 4) {
                day = Integer.parseInt(tempVal2[tempVal2.length - 4]);
            }
            LocalDateTime thisResult = nowTime.atTime(Integer.parseInt(tempVal2[tempVal2.length - 3]), Integer.parseInt(tempVal2[tempVal2.length - 2]), Integer.parseInt(tempVal2[tempVal2.length - 1]));
            thisResult = thisResult.plusDays(day).plusMonths(month);
            if (LocalDateTime.now().isAfter(thisResult)) {
                thisResult = thisResult.plusDays(1L);
            }
            if (refreshResult != null && !thisResult.isBefore(refreshResult)) continue;
            refreshResult = thisResult;
        }
        return refreshResult;
    }

    private LocalDateTime getTimerRefreshTime(String time) {
        LocalDateTime refreshResult = LocalDateTime.now();
        String[] tempVal2 = time.split(":");
        if (tempVal2.length < 3) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + time + " is invalid.");
            return LocalDateTime.now();
        }
        int month = 0;
        int day = 0;
        if (tempVal2.length == 5) {
            month = Integer.parseInt(tempVal2[0]);
        }
        if (tempVal2.length >= 4) {
            day = Integer.parseInt(tempVal2[tempVal2.length - 4]);
        }
        refreshResult = refreshResult.plusMonths(month).plusDays(day).plusHours(Integer.parseInt(tempVal2[tempVal2.length - 3])).plusMinutes(Integer.parseInt(tempVal2[tempVal2.length - 2])).plusSeconds(Integer.parseInt(tempVal2[tempVal2.length - 1]));
        return refreshResult;
    }
}

