/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.caches;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.BungeeCordManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectRandomPlaceholder;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.time.LocalDateTime;
import java.util.Objects;

public class ObjectUseTimesCache {
    private int buyUseTimes;
    private int totalBuyUseTimes;
    private int sellUseTimes;
    private int totalSellUseTimes;
    private LocalDateTime lastBuyTime = null;
    private LocalDateTime lastSellTime = null;
    private LocalDateTime lastResetBuyTime = null;
    private LocalDateTime lastResetSellTime = null;
    private LocalDateTime cooldownBuyTime = null;
    private LocalDateTime cooldownSellTime = null;
    private final ObjectItem product;
    private final ServerCache cache;
    private final boolean firstInsert;

    public ObjectUseTimesCache(ServerCache cache, int buyUseTimes, int totalBuyUseTimes, int sellUseTimes, int totalSellUseTimes, String lastBuyTime, String lastSellTime, String lastResetBuyTime, String lastResetSellTime, String cooldownBuyTime, String cooldownSellTime, ObjectItem product, boolean firstInsert) {
        this.firstInsert = firstInsert;
        this.cache = cache;
        this.buyUseTimes = buyUseTimes;
        this.totalBuyUseTimes = totalBuyUseTimes;
        if (lastBuyTime != null) {
            this.lastBuyTime = CommonUtil.stringToTime(lastBuyTime);
        }
        this.sellUseTimes = sellUseTimes;
        this.totalSellUseTimes = totalSellUseTimes;
        if (lastSellTime != null) {
            this.lastSellTime = CommonUtil.stringToTime(lastSellTime);
        }
        if (lastResetBuyTime != null) {
            this.lastResetBuyTime = CommonUtil.stringToTime(lastResetBuyTime);
        }
        if (lastResetSellTime != null) {
            this.lastResetSellTime = CommonUtil.stringToTime(lastResetSellTime);
        }
        if (cooldownBuyTime != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cSet cooldown time to " + String.valueOf(product));
            }
            this.cooldownBuyTime = CommonUtil.stringToTime(cooldownBuyTime);
        }
        if (cooldownSellTime != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cSet cooldown time to " + String.valueOf(product));
            }
            this.cooldownSellTime = CommonUtil.stringToTime(cooldownSellTime);
        }
        this.product = product;
    }

    public int getBuyUseTimes() {
        return this.buyUseTimes;
    }

    public int getTotalBuyUseTimes() {
        return 0;
    }

    public int getSellUseTimes() {
        return this.sellUseTimes;
    }

    public int getTotalSellUseTimes() {
        return 0;
    }

    public void setBuyUseTimes(int i) {
        this.setBuyUseTimes(i, false, false);
    }

    public void setBuyUseTimes(int i, boolean isReset) {
        this.setBuyUseTimes(i, false, isReset);
    }

    public void setBuyUseTimes(int i, boolean notUseBungee, boolean isReset) {
        int maxTimes = this.product.getBuyTimesMaxValue(this.cache.player);
        if (i > 2147473647) {
            this.setSellUseTimes(0);
            this.setBuyUseTimes(i - this.sellUseTimes);
        }
        if (!isReset) {
            this.totalBuyUseTimes = this.totalBuyUseTimes > 2147473647 ? i : (this.totalBuyUseTimes += i - this.buyUseTimes);
        }
        this.buyUseTimes = i;
        if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "buy-times", String.valueOf(i));
        }
    }

    public void setSellUseTimes(int i) {
        this.setSellUseTimes(i, false, false);
    }

    public void setSellUseTimes(int i, boolean isReset) {
        this.setSellUseTimes(i, false, isReset);
    }

    public void setSellUseTimes(int i, boolean notUseBungee, boolean isReset) {
        int maxTimes = this.product.getSellTimesMaxValue(this.cache.player);
        if (i > 2147473647) {
            this.setBuyUseTimes(0);
            this.setSellUseTimes(i - this.buyUseTimes);
        }
        if (!isReset) {
            this.totalSellUseTimes = this.totalSellUseTimes > 2147473647 ? i : (this.totalSellUseTimes += i - this.sellUseTimes);
        }
        this.sellUseTimes = i;
        if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "sell-times", String.valueOf(i));
        }
    }

    public void setLastBuyTime(LocalDateTime time) {
        if (time == null) {
            this.lastResetBuyTime = Objects.requireNonNullElseGet(this.cooldownBuyTime, LocalDateTime::now);
        }
        this.setLastBuyTime(time, false);
    }

    public void setLastBuyTime(LocalDateTime time, boolean notUseBungee) {
        this.lastBuyTime = time;
        if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "last-buy-time", CommonUtil.timeToString(time));
        }
    }

    public void setLastSellTime(LocalDateTime time) {
        if (time == null) {
            this.lastResetSellTime = Objects.requireNonNullElseGet(this.cooldownSellTime, LocalDateTime::now);
        }
        this.setLastSellTime(time, false);
    }

    public void setLastSellTime(LocalDateTime time, boolean notUseBungee) {
        this.lastSellTime = time;
        if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "last-sell-time", CommonUtil.timeToString(time));
        }
    }

    public void setCooldownBuyTime() {
        this.setCooldownBuyTime(false);
    }

    public void resetCooldownBuyTime() {
        this.cooldownBuyTime = null;
    }

    public void setCooldownBuyTime(boolean notUseBungee) {
        if (this.cooldownBuyTime == null || !this.cooldownBuyTime.isBefore(LocalDateTime.now())) {
            String mode = this.product.getBuyTimesResetMode();
            String tempVal1 = TextUtil.withPAPI(this.product.getBuyTimesResetTime(), this.cache.player);
            if (mode == null || tempVal1.isEmpty()) {
                return;
            }
            switch (mode) {
                case "COOLDOWN_TIMED": {
                    this.cooldownBuyTime = this.getTimedBuyRefreshTime(tempVal1);
                    if (notUseBungee || !this.cache.server || BungeeCordManager.bungeeCordManager == null) break;
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-buy-time", null);
                    break;
                }
                case "COOLDOWN_TIMER": {
                    this.cooldownBuyTime = this.getTimerBuyRefreshTime(tempVal1);
                    if (notUseBungee || !this.cache.server || BungeeCordManager.bungeeCordManager == null) break;
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-buy-time", null);
                    break;
                }
                case "COOLDOWN_CUSTOM": {
                    this.cooldownBuyTime = CommonUtil.stringToTime(tempVal1, TextUtil.withPAPI(this.product.getBuyTimesResetFormat(), this.cache.player));
                }
            }
        }
    }

    public void setCooldownSellTime() {
        this.setCooldownSellTime(false);
    }

    public void resetCooldownSellTime() {
        this.cooldownSellTime = null;
    }

    public void setCooldownSellTime(boolean notUseBungee) {
        if (this.cooldownSellTime == null || !this.cooldownSellTime.isBefore(LocalDateTime.now())) {
            String mode = this.product.getSellTimesResetMode();
            String tempVal1 = TextUtil.withPAPI(this.product.getSellTimesResetTime(), this.cache.player);
            if (mode == null || tempVal1.isEmpty()) {
                return;
            }
            switch (mode) {
                case "COOLDOWN_TIMED": {
                    this.cooldownSellTime = this.getTimedSellRefreshTime(tempVal1);
                    if (notUseBungee || !this.cache.server || BungeeCordManager.bungeeCordManager == null) break;
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-sell-time", null);
                    break;
                }
                case "COOLDOWN_TIMER": {
                    this.cooldownSellTime = this.getTimerSellRefreshTime(tempVal1);
                    if (notUseBungee || !this.cache.server || BungeeCordManager.bungeeCordManager == null) break;
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-sell-time", null);
                    break;
                }
                case "COOLDOWN_CUSTOM": {
                    this.cooldownSellTime = CommonUtil.stringToTime(tempVal1, TextUtil.withPAPI(this.product.getSellTimesResetFormat(), this.cache.player));
                }
            }
        }
    }

    public String getLastBuyTime() {
        if (this.lastBuyTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastBuyTime);
    }

    public String getLastSellTime() {
        if (this.lastSellTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastSellTime);
    }

    public String getLastResetBuyTime() {
        if (this.lastResetBuyTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastResetBuyTime);
    }

    public String getLastResetSellTime() {
        if (this.lastResetSellTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastResetSellTime);
    }

    public String getCooldownBuyTime() {
        if (this.cooldownBuyTime == null) {
            return null;
        }
        if (ConfigManager.configManager.getBoolean("debug")) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cCooldown time: " + String.valueOf(this.cooldownBuyTime));
        }
        return CommonUtil.timeToString(this.cooldownBuyTime);
    }

    public String getCooldownSellTime() {
        if (this.cooldownSellTime == null) {
            return null;
        }
        if (ConfigManager.configManager.getBoolean("debug")) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cCooldown time: " + String.valueOf(this.cooldownSellTime));
        }
        return CommonUtil.timeToString(this.cooldownSellTime);
    }

    public LocalDateTime getBuyRefreshTime() {
        String mode = this.product.getBuyTimesResetMode();
        String tempVal1 = TextUtil.withPAPI(this.product.getBuyTimesResetTime(), this.cache.player);
        return this.createRefreshTime(mode, tempVal1, true);
    }

    public LocalDateTime getSellRefreshTime() {
        String mode = this.product.getSellTimesResetMode();
        String tempVal1 = TextUtil.withPAPI(this.product.getSellTimesResetTime(), this.cache.player);
        return this.createRefreshTime(mode, tempVal1, false);
    }

    public String getBuyRefreshTimeDisplayName() {
        LocalDateTime tempVal1 = this.getBuyRefreshTime();
        if (tempVal1 == null || tempVal1.getYear() == 2999) {
            return ConfigManager.configManager.getString("placeholder.refresh.never", new String[0]);
        }
        return CommonUtil.timeToString(tempVal1, ConfigManager.configManager.getString("placeholder.refresh.format", new String[0]));
    }

    public String getBuyRefreshTimeNextName() {
        return "";
    }

    public String getBuyLastTimeName() {
        return "0";
    }

    public String getBuyLastResetTimeName() {
        return "0";
    }

    public String getSellRefreshTimeDisplayName() {
        LocalDateTime tempVal1 = this.getSellRefreshTime();
        if (tempVal1 == null || tempVal1.getYear() == 2999) {
            return ConfigManager.configManager.getString("placeholder.refresh.never", new String[0]);
        }
        return CommonUtil.timeToString(tempVal1, ConfigManager.configManager.getString("placeholder.refresh.format", new String[0]));
    }

    public String getSellRefreshTimeNextName() {
        return "0";
    }

    public String getSellLastTimeName() {
        return "0";
    }

    public String getSellLastResetTimeName() {
        return "0";
    }

    private LocalDateTime getTimedBuyRefreshTime(String time) {
        LocalDateTime refreshResult;
        block6: {
            refreshResult = null;
            int n = 0;
            String[] tempVal3 = time.split(";;");
            String[] stringArray = tempVal3;
            int n2 = stringArray.length;
            if (n >= n2) break block6;
            String tempVal4 = stringArray[n];
            String[] tempVal2 = tempVal4.split(":");
            int month = 0;
            int day = 0;
            if (tempVal2.length < 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + tempVal4 + " is invalid.");
                return LocalDateTime.now();
            }
            if (tempVal2.length == 5) {
                month = Integer.parseInt(tempVal2[0]);
            }
            if (tempVal2.length >= 4) {
                day = Integer.parseInt(tempVal2[tempVal2.length - 4]);
            }
            LocalDateTime checkTime = this.lastBuyTime;
            if (this.lastBuyTime == null) {
                checkTime = LocalDateTime.now();
            }
            LocalDateTime thisResult = checkTime.withHour(Integer.parseInt(tempVal2[tempVal2.length - 3])).withMinute(Integer.parseInt(tempVal2[tempVal2.length - 2])).withSecond(Integer.parseInt(tempVal2[tempVal2.length - 1]));
            if (!checkTime.isBefore(thisResult = thisResult.plusDays(day).plusMonths(month))) {
                thisResult = thisResult.plusDays(1L);
            }
            if (refreshResult == null || thisResult.isBefore(refreshResult)) {
                refreshResult = thisResult;
            }
        }
        return refreshResult;
    }

    private LocalDateTime getTimedSellRefreshTime(String time) {
        LocalDateTime refreshResult;
        block6: {
            refreshResult = null;
            int n = 0;
            String[] tempVal3 = time.split(";;");
            String[] stringArray = tempVal3;
            int n2 = stringArray.length;
            if (n >= n2) break block6;
            String tempVal4 = stringArray[n];
            String[] tempVal2 = tempVal4.split(":");
            int month = 0;
            int day = 0;
            if (tempVal2.length < 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + tempVal4 + " is invalid.");
                return LocalDateTime.now();
            }
            if (tempVal2.length == 5) {
                month = Integer.parseInt(tempVal2[0]);
            }
            if (tempVal2.length >= 4) {
                day = Integer.parseInt(tempVal2[1]);
            }
            LocalDateTime checkTime = this.lastSellTime;
            if (this.lastSellTime == null) {
                checkTime = LocalDateTime.now();
            }
            LocalDateTime thisResult = checkTime.withHour(Integer.parseInt(tempVal2[tempVal2.length - 3])).withMinute(Integer.parseInt(tempVal2[tempVal2.length - 2])).withSecond(Integer.parseInt(tempVal2[tempVal2.length - 1]));
            if (!checkTime.isBefore(thisResult = thisResult.plusDays(day).plusMonths(month))) {
                thisResult = thisResult.plusDays(1L);
            }
            if (refreshResult == null || thisResult.isBefore(refreshResult)) {
                refreshResult = thisResult;
            }
        }
        return refreshResult;
    }

    private LocalDateTime getTimerBuyRefreshTime(String time) {
        String[] tempVal2;
        LocalDateTime refreshResult = this.lastBuyTime;
        if (refreshResult == null) {
            refreshResult = LocalDateTime.now();
        }
        if ((tempVal2 = time.split(":")).length < 3) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + time + " is invalid.");
            return LocalDateTime.now();
        }
        int month = 0;
        int day = 0;
        refreshResult = refreshResult.plusMonths(month).plusDays(day).plusHours(Integer.parseInt(tempVal2[tempVal2.length - 3])).plusMinutes(Integer.parseInt(tempVal2[tempVal2.length - 2])).plusSeconds(Integer.parseInt(tempVal2[tempVal2.length - 1]));
        return refreshResult;
    }

    private LocalDateTime getTimerSellRefreshTime(String time) {
        String[] tempVal2;
        LocalDateTime refreshResult = this.lastSellTime;
        if (refreshResult == null) {
            refreshResult = LocalDateTime.now();
        }
        if ((tempVal2 = time.split(":")).length < 3) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + time + " is invalid.");
            return LocalDateTime.now();
        }
        int month = 0;
        int day = 0;
        refreshResult = refreshResult.plusMonths(month).plusDays(day).plusHours(Integer.parseInt(tempVal2[tempVal2.length - 3])).plusMinutes(Integer.parseInt(tempVal2[tempVal2.length - 2])).plusSeconds(Integer.parseInt(tempVal2[tempVal2.length - 1]));
        return refreshResult;
    }

    private LocalDateTime createRefreshTime(String mode, String time, boolean buyOrSell) {
        switch (mode) {
            case "COOLDOWN_TIMED": 
            case "COOLDOWN_TIMER": 
            case "COOLDOWN_CUSTOM": {
                return LocalDateTime.now();
            }
            case "TIMED": {
                if (buyOrSell) {
                    return this.getTimedBuyRefreshTime(time);
                }
                return this.getTimedSellRefreshTime(time);
            }
            case "TIMER": {
                if (buyOrSell) {
                    return this.getTimerBuyRefreshTime(time);
                }
                return this.getTimerSellRefreshTime(time);
            }
            case "CUSTOM": {
                return CommonUtil.stringToTime(time);
            }
            case "RANDOM_PLACEHOLDER": {
                return ObjectRandomPlaceholder.getRefreshDoneTimeObject(this.cache.player, time);
            }
        }
        return LocalDateTime.now().withYear(2999);
    }

    public void refreshBuyTimes() {
        LocalDateTime tempVal1 = this.getBuyRefreshTime();
        if (tempVal1 != null && tempVal1.isBefore(LocalDateTime.now())) {
            this.setBuyUseTimes(this.product.getBuyTimesResetValue(this.cache.player), true);
            this.setLastBuyTime(null);
            this.resetCooldownBuyTime();
        }
    }

    public void refreshSellTimes() {
        LocalDateTime tempVal1 = this.getSellRefreshTime();
        if (tempVal1 != null && tempVal1.isBefore(LocalDateTime.now())) {
            this.setSellUseTimes(this.product.getSellTimesResetValue(this.cache.player), true);
            this.setLastSellTime(null);
            this.resetCooldownSellTime();
        }
    }

    public boolean isEmpty() {
        return this.buyUseTimes == 0 && this.totalBuyUseTimes == 0 && this.sellUseTimes == 0 && this.totalSellUseTimes == 0;
    }

    public boolean isFirstInsert() {
        return this.firstInsert;
    }
}

