/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.conditions.ObjectSingleCondition;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class ObjectCondition {
    private ConfigurationSection section;
    private boolean isEmpty = false;
    private ObjectShop shop = null;
    private ObjectItem item = null;
    private final List<ObjectSingleCondition> conditions = new ArrayList<ObjectSingleCondition>();

    public ObjectCondition() {
        this.section = new MemoryConfiguration();
    }

    public ObjectCondition(ConfigurationSection section) {
        this.section = section;
        this.initCondition();
    }

    public ObjectCondition(ConfigurationSection section, ObjectShop shop) {
        this.section = section;
        this.shop = shop;
        this.initCondition();
    }

    public ObjectCondition(ConfigurationSection section, ObjectItem item) {
        this.section = section;
        this.item = item;
        this.initCondition();
    }

    private void initCondition() {
        if (this.section == null) {
            this.isEmpty = true;
            this.section = new MemoryConfiguration();
            return;
        }
        for (String key : this.section.getKeys(false)) {
            ConfigurationSection singleActionSection = this.section.getConfigurationSection(key);
            if (singleActionSection == null) continue;
            ObjectSingleCondition singleAction = this.item != null ? new ObjectSingleCondition(this, singleActionSection, this.item) : (this.shop != null ? new ObjectSingleCondition(this, singleActionSection, this.shop) : new ObjectSingleCondition(this, singleActionSection));
            this.conditions.add(singleAction);
        }
        this.isEmpty = this.conditions.isEmpty();
    }

    public boolean getAllBoolean(ObjectThingRun thingRun) {
        if (thingRun.getPlayer() == null) {
            return false;
        }
        for (ObjectSingleCondition singleCondition : this.conditions) {
            if (singleCondition.checkBoolean(thingRun)) continue;
            return false;
        }
        return true;
    }

    public boolean getAnyBoolean(ObjectThingRun thingRun) {
        if (thingRun.getPlayer() == null) {
            return false;
        }
        for (ObjectSingleCondition singleCondition : this.conditions) {
            if (!singleCondition.checkBoolean(thingRun)) continue;
            return true;
        }
        return false;
    }
}

