/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.MathUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ObjectLimit {
    private ConfigurationSection limitSection;
    private ConfigurationSection conditionsSection;
    private ObjectItem item;

    public ObjectLimit() {
    }

    public ObjectLimit(ConfigurationSection limitSection, ConfigurationSection conditionsSection, ObjectItem item) {
        this.limitSection = limitSection;
        this.conditionsSection = conditionsSection;
        this.item = item;
    }

    public int getPlayerLimits(Player player) {
        if (this.limitSection == null) {
            return -1;
        }
        if (this.conditionsSection == null) {
            return this.checkLimitValue(player, "default");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String conditionName : this.limitSection.getKeys(false)) {
            if (conditionName.equals("default") || conditionName.equals("global") || !this.checkLimitsCondition(conditionName, player)) continue;
            result.add(this.checkLimitValue(player, conditionName));
        }
        result.add(this.checkLimitValue(player, "default"));
        return (Integer)Collections.max(result);
    }

    public int getServerLimits(Player player) {
        if (this.limitSection == null) {
            return -1;
        }
        int tempVal2 = -1;
        String tempVal1 = this.limitSection.getString("global", "-1");
        if (!tempVal1.equals("-1")) {
            tempVal2 = this.checkLimitValue(player, "global");
        }
        return tempVal2;
    }

    private boolean checkLimitsCondition(String conditionName, Player player) {
        ObjectCondition tempVal1 = new ObjectCondition(this.conditionsSection.getConfigurationSection(conditionName));
        return tempVal1.getAllBoolean(new ObjectThingRun(player));
    }

    private int checkLimitValue(Player player, String path) {
        int tempVal2 = -1;
        String tempVal1 = this.limitSection.getString(path, "-1");
        if (!tempVal1.equals("-1")) {
            if (this.item != null && ConfigManager.configManager.getBoolean("placeholder.data.can-used-in-amount")) {
                int playerBuyTimes = 0;
                int playerSellTimes = 0;
                int playerTotalBuyTimes = 0;
                int playerTotalSellTimes = 0;
                int serverBuyTimes = 0;
                int serverSellTimes = 0;
                int serverTotalBuyTimes = 0;
                int serverTotalSellTimes = 0;
                ObjectUseTimesCache tempVal3 = CacheManager.cacheManager.getPlayerCache(player).getUseTimesCache().get(this.item);
                ObjectUseTimesCache tempVal4 = CacheManager.cacheManager.serverCache.getUseTimesCache().get(this.item);
                if (tempVal3 != null) {
                    playerBuyTimes = tempVal3.getBuyUseTimes();
                    playerSellTimes = tempVal3.getSellUseTimes();
                    playerTotalBuyTimes = tempVal3.getTotalBuyUseTimes();
                    playerTotalSellTimes = tempVal3.getTotalSellUseTimes();
                }
                if (tempVal4 != null) {
                    serverBuyTimes = tempVal4.getBuyUseTimes();
                    serverSellTimes = tempVal4.getSellUseTimes();
                    serverTotalBuyTimes = tempVal4.getTotalBuyUseTimes();
                    serverTotalSellTimes = tempVal4.getTotalSellUseTimes();
                }
                tempVal1 = CommonUtil.modifyString(tempVal1, "buy-times-player", String.valueOf(playerBuyTimes), "sell-times-player", String.valueOf(playerSellTimes), "buy-times-server", String.valueOf(serverBuyTimes), "sell-times-server", String.valueOf(serverSellTimes), "buy-total-player", String.valueOf(playerTotalBuyTimes), "sell-total-player", String.valueOf(playerTotalSellTimes), "buy-total-server", String.valueOf(serverTotalBuyTimes), "sell-total-server", String.valueOf(serverTotalSellTimes), "last-buy-player", tempVal3 != null ? tempVal3.getBuyLastTimeName() : "", "last-sell-player", tempVal3 != null ? tempVal3.getSellLastTimeName() : "", "last-buy-server", tempVal4 != null ? tempVal4.getBuyLastTimeName() : "", "last-sell-server", tempVal4 != null ? tempVal4.getSellLastTimeName() : "", "last-reset-buy-player", tempVal3 != null ? tempVal3.getBuyLastResetTimeName() : "", "last-reset-sell-player", tempVal3 != null ? tempVal3.getSellLastResetTimeName() : "", "last-reset-buy-server", tempVal4 != null ? tempVal4.getBuyLastResetTimeName() : "", "last-reset-sell-server", tempVal4 != null ? tempVal4.getSellLastResetTimeName() : "");
            }
            tempVal2 = MathUtil.doCalculate(TextUtil.withPAPI(tempVal1, player)).intValue();
        }
        return tempVal2;
    }
}

