/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.prices;

import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.methods.StaticPlaceholder;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.objects.items.prices.PriceMode;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.MathUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ObjectSinglePrice
extends AbstractSingleThing {
    private Map<Integer, BigDecimal> applyCostMap = new HashMap<Integer, BigDecimal>();
    private boolean customPrice;
    private ObjectItem item;
    private PriceMode priceMode;
    private boolean isStatic;
    private boolean isAlwaysApply = false;
    private BigDecimal baseAmount;
    private String amountOption;

    public ObjectSinglePrice() {
    }

    public ObjectSinglePrice(String id, ObjectPrices prices) {
        super(id, prices);
        Pattern pattern;
        Matcher matcher;
        this.item = prices.getItem();
        this.priceMode = prices.getPriceMode();
        this.things = prices;
        this.amountOption = this.singleSection.getString("amount", "1");
        String tempVal1 = ConfigManager.configManager.getString("prices." + this.singleSection.getString("custom-type") + ".amount", "1");
        if (this.singleSection.getString("custom-type") != null && tempVal1 != null) {
            this.amountOption = tempVal1;
        }
        this.isStatic = this.amountOption.matches("-?\\d+(\\.\\d+)?");
        if (!(this.amountOption.contains("{conditional_") || !ConfigManager.configManager.getBooleanOrDefault("placeholder.auto-settings.add-discount-in-all-price-amount.enabled", "placeholder.auto-settings.add-conditional-in-all-price-amount.enabled") || ConfigManager.configManager.getStringListOrDefault("placeholder.auto-settings.add-discount-in-all-price-amount.black-shops", "placeholder.auto-settings.add-conditional-in-all-price-amount.black-shops").contains(prices.getItem().getShop()) || ConfigManager.configManager.getBooleanOrDefault("placeholder.auto-settings.add-discount-in-all-price-amount.black-dynamic-price", "placeholder.auto-settings.add-conditional-in-all-price-amount.black-dynamic-price") && !this.isStatic)) {
            this.amountOption = prices.getPriceMode() == PriceMode.BUY ? "{conditional_" + ConfigManager.configManager.getStringOrDefault("placeholder.auto-settings.add-discount-in-all-price-amount.buy-placeholder", "placeholder.auto-settings.add-conditional-in-all-price-amount.black-dynamic-price", "") + "} * (" + this.amountOption + ")" : "{conditional_" + ConfigManager.configManager.getStringOrDefault("placeholder.auto-settings.add-discount-in-all-price-amount.sell-placeholder", "placeholder.auto-settings.add-conditional-in-all-price-amount.sell-placeholder", "") + "} * (" + this.amountOption + ")";
            this.isStatic = false;
        }
        if ((matcher = (pattern = Pattern.compile("-?\\d+(\\.\\d+)?")).matcher(this.amountOption)).find()) {
            this.baseAmount = new BigDecimal(matcher.group());
        }
        this.initCustomMode();
        this.initApplyCostMap();
        this.initCondition();
        this.initAction();
    }

    private void initCustomMode() {
        this.customPrice = !this.singleSection.getString("custom-type", "none").equals("none");
    }

    private void initApplyCostMap() {
        if (Objects.isNull(this.singleSection) || this.singleSection.getInt("start-apply", -1) != -1 && this.singleSection.getInt("end-apply", -1) != -1) {
            this.isAlwaysApply = true;
            return;
        }
        List apply = this.singleSection.getIntegerList("apply");
        List cost = this.singleSection.getDoubleList("cost");
        while (apply.size() > cost.size()) {
            if (!cost.isEmpty()) {
                cost.add((Double)cost.get(cost.size() - 1));
                continue;
            }
            cost.add(-1.0);
        }
        HashMap<Integer, BigDecimal> applyCostMap = new HashMap<Integer, BigDecimal>();
        for (int i = 0; i < apply.size(); ++i) {
            applyCostMap.put((Integer)apply.get(i), BigDecimal.valueOf((Double)cost.get(i)));
        }
        this.applyCostMap = applyCostMap;
    }

    @Override
    public boolean playerHasEnough(Inventory inventory, Player player, boolean take, double cost) {
        if (this.singleSection == null) {
            return false;
        }
        if (this.customPrice) {
            return super.playerHasEnough(inventory, ConfigManager.configManager.config.getConfigurationSection("prices." + this.singleSection.getString("custom-type")), player, take, cost);
        }
        return super.playerHasEnough(inventory, this.singleSection, player, take, cost);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public BigDecimal getAmount(Player player, int times, int offsetAmount) {
        BigDecimal minAmount;
        BigDecimal maxAmount;
        BigDecimal cost;
        if (this.singleSection == null) {
            return new BigDecimal(-1);
        }
        if (this.isStatic()) {
            cost = this.baseAmount;
        } else {
            String tempVal1 = this.amountOption;
            if (this.item != null && ConfigManager.configManager.getBoolean("placeholder.data.can-used-in-amount")) {
                int playerBuyTimes = 0;
                int playerSellTimes = 0;
                int playerTotalBuyTimes = 0;
                int playerTotalSellTimes = 0;
                int serverBuyTimes = 0;
                int serverSellTimes = 0;
                int serverTotalBuyTimes = 0;
                int serverTotalSellTimes = 0;
                ObjectUseTimesCache tempVal3 = CacheManager.cacheManager.getPlayerCache(player).getUseTimesCache().get(this.item);
                ObjectUseTimesCache tempVal4 = CacheManager.cacheManager.serverCache.getUseTimesCache().get(this.item);
                if (tempVal3 != null) {
                    playerBuyTimes = tempVal3.getBuyUseTimes();
                    playerSellTimes = tempVal3.getSellUseTimes();
                    playerTotalBuyTimes = tempVal3.getTotalBuyUseTimes();
                    playerTotalSellTimes = tempVal3.getTotalSellUseTimes();
                }
                if (tempVal4 != null) {
                    serverBuyTimes = tempVal4.getBuyUseTimes();
                    serverSellTimes = tempVal4.getSellUseTimes();
                    serverTotalBuyTimes = tempVal4.getTotalBuyUseTimes();
                    serverTotalSellTimes = tempVal4.getTotalSellUseTimes();
                }
                tempVal1 = CommonUtil.modifyString(tempVal1, "buy-times-player", this.replacePlaceholder(playerBuyTimes, offsetAmount, true), "sell-times-player", this.replacePlaceholder(playerSellTimes, offsetAmount, false), "buy-times-server", this.replacePlaceholder(serverBuyTimes, offsetAmount, true), "sell-times-server", this.replacePlaceholder(serverSellTimes, offsetAmount, false), "buy-total-player", this.replacePlaceholder(playerTotalBuyTimes, offsetAmount, true), "sell-total-player", this.replacePlaceholder(playerTotalSellTimes, offsetAmount, false), "buy-total-server", this.replacePlaceholder(serverTotalBuyTimes, offsetAmount, true), "sell-total-server", this.replacePlaceholder(serverTotalSellTimes, offsetAmount, false), "last-buy-player", tempVal3 != null ? tempVal3.getBuyLastTimeName() : "", "last-sell-player", tempVal3 != null ? tempVal3.getSellLastTimeName() : "", "last-buy-server", tempVal4 != null ? tempVal4.getBuyLastTimeName() : "", "last-sell-server", tempVal4 != null ? tempVal4.getSellLastTimeName() : "", "last-reset-buy-player", tempVal3 != null ? tempVal3.getBuyLastResetTimeName() : "", "last-reset-sell-player", tempVal3 != null ? tempVal3.getSellLastResetTimeName() : "", "last-reset-buy-server", tempVal4 != null ? tempVal4.getBuyLastResetTimeName() : "", "last-reset-sell-server", tempVal4 != null ? tempVal4.getSellLastResetTimeName() : "");
            }
            cost = MathUtil.doCalculate(TextUtil.withPAPI(tempVal1, player));
        }
        if (this.singleSection.getString("max-amount") != null && cost.compareTo(maxAmount = new BigDecimal(TextUtil.withPAPI(this.singleSection.getString("max-amount"), player))) > 0) {
            cost = maxAmount;
        }
        if (this.singleSection.getString("min-amount") != null && cost.compareTo(minAmount = new BigDecimal(TextUtil.withPAPI(this.singleSection.getString("min-amount"), player))) < 0) {
            cost = minAmount;
        }
        if (!this.applyCostMap.isEmpty() && this.applyCostMap.containsKey(times) && this.applyCostMap.get(times).compareTo(new BigDecimal(-1)) == 0) {
            cost = this.applyCostMap.get(times);
        }
        return cost.setScale(MathUtil.scale, RoundingMode.HALF_UP);
    }

    @Override
    public String getDisplayName(int multi, BigDecimal amount, boolean alwaysStatic) {
        if (this.empty) {
            return ConfigManager.configManager.getString("placeholder.price.empty", new String[0]);
        }
        if (this.singleSection == null) {
            return ConfigManager.configManager.getString("placeholder.price.unknown", new String[0]);
        }
        String tempVal1 = this.singleSection.getString("placeholder", ConfigManager.configManager.getString("placeholder.price.unknown", new String[0]));
        String tempVal2 = this.customPrice ? ConfigManager.configManager.getString("prices." + this.singleSection.getString("custom-type") + ".placeholder", tempVal1) : this.singleSection.getString("placeholder", tempVal1);
        if (alwaysStatic || tempVal2.contains("{status}") || this.isStatic || this.baseAmount != null) {
            // empty if block
        }
        if (tempVal2.contains("{amount}") && ConfigManager.configManager.getBoolean("placeholder.auto-settings.change-amount-in-all-price-placeholder.enabled")) {
            tempVal2 = tempVal2.replace("{amount}", ConfigManager.configManager.getString("placeholder.auto-settings.change-amount-in-all-price-placeholder.replace-value", "{amount}"));
        }
        return CommonUtil.modifyString(tempVal2, "amount", String.valueOf(amount), "status", alwaysStatic || this.baseAmount == null ? "" : StaticPlaceholder.getCompareValue(this.baseAmount.multiply(new BigDecimal(multi)), amount));
    }

    public int getStartApply() {
        if (this.isAlwaysApply || this.singleSection == null) {
            return -1;
        }
        return this.singleSection.getInt("start-apply", -1);
    }

    public int getEndApply() {
        if (this.isAlwaysApply || this.singleSection == null) {
            return Integer.MAX_VALUE;
        }
        return this.singleSection.getInt("end-apply", Integer.MAX_VALUE);
    }

    public boolean isAlwaysApply() {
        return this.isAlwaysApply;
    }

    public Map<Integer, BigDecimal> getApplyCostMap() {
        return this.applyCostMap;
    }

    public boolean getCustomPrice() {
        return this.customPrice;
    }

    private String replacePlaceholder(int baseAmount, int offsetAmount, boolean buyOrSell) {
        if (buyOrSell && this.priceMode == PriceMode.BUY || !buyOrSell && this.priceMode == PriceMode.SELL) {
            return String.valueOf(baseAmount + offsetAmount);
        }
        return String.valueOf(baseAmount);
    }

    public ObjectItem getItem() {
        return this.item;
    }

    public String toString() {
        if (this.singleSection == null) {
            return "Empty Price";
        }
        return "Named Price: " + this.singleSection.getName();
    }
}

