/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.products;

import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.AbstractThings;
import cn.superiormc.ultimateshop.objects.items.GiveResult;
import cn.superiormc.ultimateshop.objects.items.MaxSellResult;
import cn.superiormc.ultimateshop.objects.items.TakeResult;
import cn.superiormc.ultimateshop.objects.items.ThingMode;
import cn.superiormc.ultimateshop.objects.items.products.ObjectSingleProduct;
import cn.superiormc.ultimateshop.utils.RandomUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ObjectProducts
extends AbstractThings {
    public Collection<ObjectSingleProduct> singleProducts = new TreeSet<ObjectSingleProduct>();

    public ObjectProducts() {
    }

    public ObjectProducts(ConfigurationSection section, String mode, ObjectItem item) {
        super(section, mode, item);
        this.initSingleProducts();
    }

    public void initSingleProducts() {
        boolean allIsStatic = true;
        for (String s : this.section.getKeys(false)) {
            if (this.section.getConfigurationSection(s) == null) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not get products section in your shop config!!");
                this.singleProducts.add(new ObjectSingleProduct());
                continue;
            }
            ObjectSingleProduct singleProduct = new ObjectSingleProduct(s, this);
            this.singleProducts.add(singleProduct);
            if (singleProduct.isStatic()) continue;
            allIsStatic = false;
        }
        if (allIsStatic) {
            if (this.mode.equals((Object)ThingMode.ANY)) {
                this.mode = ThingMode.CLASSIC_ANY;
            } else if (this.mode.equals((Object)ThingMode.ALL)) {
                this.mode = ThingMode.CLASSIC_ALL;
            }
        }
        this.empty = this.singleProducts.isEmpty();
    }

    @Override
    public GiveResult give(Player player, int times, int amount) {
        TreeMap<AbstractSingleThing, BigDecimal> result = new TreeMap<AbstractSingleThing, BigDecimal>();
        GiveResult resultObject = new GiveResult(result);
        if (this.section == null || this.singleProducts.isEmpty()) {
            return resultObject;
        }
        ArrayList<ObjectSingleProduct> tempVal6 = new ArrayList<ObjectSingleProduct>();
        switch (this.mode) {
            case UNKNOWN: {
                return resultObject;
            }
            case ANY: 
            case CLASSIC_ANY: {
                for (ObjectSingleProduct tempVal5 : this.singleProducts) {
                    if (!tempVal5.getCondition(player)) continue;
                    tempVal6.add(tempVal5);
                }
                if (tempVal6.isEmpty()) {
                    return resultObject;
                }
                ObjectSingleProduct tempVal1 = (ObjectSingleProduct)RandomUtil.getRandomElement(tempVal6);
                BigDecimal cost = this.getAmount(player, times, amount, true).get(tempVal1);
                resultObject.addResultMapElement(tempVal1, cost);
                return resultObject;
            }
            case ALL: 
            case CLASSIC_ALL: {
                for (ObjectSingleProduct tempVal2 : this.singleProducts) {
                    if (!tempVal2.getCondition(player)) continue;
                    BigDecimal cost = this.getAmount(player, times, amount, true).get(tempVal2);
                    resultObject.addResultMapElement(tempVal2, cost);
                }
                return resultObject;
            }
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not get price-mode section in your shop config!!");
        return resultObject;
    }

    @Override
    public TakeResult take(Inventory inventory, Player player, int times, int amount, boolean test) {
        TreeMap<AbstractSingleThing, BigDecimal> result = new TreeMap<AbstractSingleThing, BigDecimal>();
        TakeResult resultObject = new TakeResult(result);
        if (this.section == null) {
            return resultObject;
        }
        boolean needFalse = false;
        switch (this.mode) {
            case UNKNOWN: {
                return resultObject;
            }
            case ANY: 
            case CLASSIC_ANY: {
                for (ObjectSingleProduct tempVal1 : this.singleProducts) {
                    if (!tempVal1.getCondition(player)) continue;
                    BigDecimal cost = this.getAmount(player, times, amount, false).get(tempVal1);
                    resultObject.addResultMapElement(tempVal1, cost);
                    if (test || !tempVal1.playerHasEnough(inventory, player, false, cost.doubleValue())) continue;
                    resultObject.setResultBoolean();
                    return resultObject;
                }
                return resultObject;
            }
            case ALL: 
            case CLASSIC_ALL: {
                for (ObjectSingleProduct tempVal1 : this.singleProducts) {
                    if (!tempVal1.getCondition(player)) continue;
                    BigDecimal cost = this.getAmount(player, times, amount, false).get(tempVal1);
                    resultObject.addResultMapElement(tempVal1, cost);
                    if (test || tempVal1.playerHasEnough(inventory, player, false, cost.doubleValue())) continue;
                    needFalse = true;
                }
                if (!needFalse) {
                    resultObject.setResultBoolean();
                }
                return resultObject;
            }
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not get price-mode section in your shop config!!");
        return resultObject;
    }

    public Map<ObjectSingleProduct, BigDecimal> getAmount(Player player, int times, int multi, boolean buyOrSell) {
        TreeMap<ObjectSingleProduct, BigDecimal> productMaps = new TreeMap<ObjectSingleProduct, BigDecimal>();
        switch (this.mode) {
            case ANY: 
            case ALL: {
                for (int i = 0; i < multi; ++i) {
                    for (ObjectSingleProduct tempVal3 : this.singleProducts) {
                        if (productMaps.containsKey(tempVal3)) {
                            productMaps.put(tempVal3, ((BigDecimal)productMaps.get(tempVal3)).add(tempVal3.getAmount(player, i, buyOrSell)));
                            continue;
                        }
                        productMaps.put(tempVal3, tempVal3.getAmount(player, i, buyOrSell));
                    }
                }
                break;
            }
            case CLASSIC_ANY: 
            case CLASSIC_ALL: {
                for (ObjectSingleProduct tempVal3 : this.singleProducts) {
                    if (productMaps.containsKey(tempVal3)) {
                        productMaps.put(tempVal3, ((BigDecimal)productMaps.get(tempVal3)).add(tempVal3.getAmount(player, 0, buyOrSell).multiply(new BigDecimal(multi))));
                        continue;
                    }
                    productMaps.put(tempVal3, tempVal3.getAmount(player, 0, buyOrSell).multiply(new BigDecimal(multi)));
                }
                break;
            }
        }
        return productMaps;
    }

    public MaxSellResult getMaxAbleSellAmount(Inventory inventory, Player player, int times, int multi, int maxLimit) {
        int maxAmount = -1;
        MaxSellResult sellResult = new MaxSellResult();
        switch (this.mode) {
            case UNKNOWN: {
                return MaxSellResult.empty;
            }
            case ANY: 
            case CLASSIC_ANY: {
                boolean breakThisTime = false;
                boolean needTrue = true;
                for (ObjectSingleProduct tempVal1 : this.singleProducts) {
                    if (!tempVal1.getCondition(player)) continue;
                    if (!tempVal1.isStatic()) {
                        ErrorManager.errorManager.sendErrorMessage("\u00a76Warning: It seems that one of your product is using dynamic amounts, which results in an error in calculating the maximum sellable quantity for that product in the sell all, as the results of each sale are different and the plugin cannot predict the price for the next sale.");
                    }
                    BigDecimal cost = this.getAmount(player, times, 1, false).get(tempVal1);
                    int tempVal2 = (int)(tempVal1.playerHasAmount(inventory, player) / cost.doubleValue());
                    if (tempVal2 <= 0) continue;
                    if (maxAmount < 0) {
                        maxAmount = 0;
                    }
                    if (tempVal2 + maxAmount >= maxLimit) {
                        tempVal2 = maxLimit - maxAmount;
                        maxAmount = maxLimit;
                        breakThisTime = true;
                    } else {
                        maxAmount = tempVal2 + maxAmount;
                    }
                    BigDecimal realCost = this.getAmount(player, times, tempVal2, false).get(tempVal1);
                    if (tempVal1.playerHasEnough(inventory, player, false, realCost.doubleValue())) {
                        sellResult.getTakeResult().addResultMapElement(tempVal1, realCost);
                    } else {
                        needTrue = false;
                    }
                    if (!breakThisTime) continue;
                    break;
                }
                if (needTrue && maxAmount > 0) {
                    sellResult.getTakeResult().setResultBoolean();
                }
                sellResult.setMaxAmount(maxAmount);
                return sellResult;
            }
            case ALL: 
            case CLASSIC_ALL: {
                boolean needFalse = false;
                for (ObjectSingleProduct tempVal1 : this.singleProducts) {
                    if (!tempVal1.getCondition(player)) continue;
                    if (!tempVal1.isStatic()) {
                        ErrorManager.errorManager.sendErrorMessage("\u00a76Warning: It seems that one of your product is using dynamic amounts, which results in an error in calculating the maximum sellable quantity for that product in the sell all, as the results of each sale are different and the plugin cannot predict the price for the next sale.");
                    }
                    BigDecimal cost = this.getAmount(player, times, 1, false).get(tempVal1);
                    int tempVal2 = (int)(tempVal1.playerHasAmount(inventory, player) / cost.doubleValue());
                    if (maxAmount != -1 && tempVal2 >= maxAmount) continue;
                    maxAmount = tempVal2;
                }
                if (maxAmount >= maxLimit) {
                    maxAmount = maxLimit;
                }
                if (maxAmount > 0) {
                    for (ObjectSingleProduct tempVal1 : this.singleProducts) {
                        if (!tempVal1.getCondition(player)) continue;
                        BigDecimal realCost = this.getAmount(player, times, maxAmount, false).get(tempVal1);
                        sellResult.getTakeResult().addResultMapElement(tempVal1, realCost);
                        if (tempVal1.playerHasEnough(inventory, player, false, realCost.doubleValue())) continue;
                        needFalse = true;
                    }
                    if (!needFalse) {
                        sellResult.getTakeResult().setResultBoolean();
                    }
                }
                sellResult.setMaxAmount(maxAmount);
                return sellResult;
            }
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not get price-mode section in your shop config!!");
        return MaxSellResult.empty;
    }

    public ObjectSingleProduct getTargetProduct(Player player) {
        for (ObjectSingleProduct tempVal1 : this.singleProducts) {
            if (!tempVal1.getCondition(player)) continue;
            return tempVal1;
        }
        return null;
    }
}

