/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.products;

import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.methods.StaticPlaceholder;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.products.ObjectProducts;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.MathUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public class ObjectSingleProduct
extends AbstractSingleThing {
    private ObjectItem item;
    private boolean isStatic;
    private BigDecimal baseAmount;

    public ObjectSingleProduct() {
    }

    public ObjectSingleProduct(String id, ObjectProducts products) {
        super(id, products);
        this.item = products.getItem();
        this.things = products;
        this.isStatic = this.singleSection.getString("amount", "1").matches("-?\\d+(\\.\\d+)?");
        Pattern pattern = Pattern.compile("-?\\d+(\\.\\d+)?");
        Matcher matcher = pattern.matcher(this.singleSection.getString("amount", "1"));
        if (matcher.find()) {
            this.baseAmount = new BigDecimal(matcher.group());
        }
        this.initCondition();
        this.initAction();
    }

    @Override
    public String getDisplayName(int multi, BigDecimal amount, boolean alwaysStatic) {
        if (this.singleSection == null) {
            return ConfigManager.configManager.getString("placeholder.price.unknown", new String[0]);
        }
        String tempVal1 = this.singleSection.getString("placeholder", ConfigManager.configManager.getString("placeholder.price.unknown", new String[0]));
        return CommonUtil.modifyString(tempVal1, "amount", String.valueOf(amount), "status", alwaysStatic ? "" : StaticPlaceholder.getCompareValue(this.baseAmount.multiply(new BigDecimal(multi)), amount));
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public BigDecimal getAmount(Player player, int offsetAmount, boolean buyOrSell) {
        BigDecimal minAmount;
        BigDecimal maxAmount;
        BigDecimal cost;
        String tempVal1 = this.singleSection.getString("amount", "1");
        if (this.isStatic()) {
            cost = this.baseAmount;
        } else {
            if (this.item != null && ConfigManager.configManager.getBoolean("placeholder.data.can-used-in-amount")) {
                int playerBuyTimes = 0;
                int playerSellTimes = 0;
                int playerTotalBuyTimes = 0;
                int playerTotalSellTimes = 0;
                int serverBuyTimes = 0;
                int serverSellTimes = 0;
                int serverTotalBuyTimes = 0;
                int serverTotalSellTimes = 0;
                ObjectUseTimesCache tempVal3 = CacheManager.cacheManager.getPlayerCache(player).getUseTimesCache().get(this.item);
                ObjectUseTimesCache tempVal4 = CacheManager.cacheManager.serverCache.getUseTimesCache().get(this.item);
                if (tempVal3 != null) {
                    playerBuyTimes = tempVal3.getBuyUseTimes();
                    playerSellTimes = tempVal3.getSellUseTimes();
                    playerTotalBuyTimes = tempVal3.getTotalBuyUseTimes();
                    playerTotalSellTimes = tempVal3.getTotalSellUseTimes();
                }
                if (tempVal4 != null) {
                    serverBuyTimes = tempVal4.getBuyUseTimes();
                    serverSellTimes = tempVal4.getSellUseTimes();
                    serverTotalBuyTimes = tempVal4.getTotalBuyUseTimes();
                    serverTotalSellTimes = tempVal4.getTotalSellUseTimes();
                }
                tempVal1 = CommonUtil.modifyString(tempVal1, "buy-times-player", this.replacePlaceholder(playerBuyTimes, offsetAmount, buyOrSell, true), "sell-times-player", this.replacePlaceholder(playerSellTimes, offsetAmount, buyOrSell, false), "buy-times-server", this.replacePlaceholder(serverBuyTimes, offsetAmount, buyOrSell, true), "sell-times-server", this.replacePlaceholder(serverSellTimes, offsetAmount, buyOrSell, false), "buy-total-player", this.replacePlaceholder(playerTotalBuyTimes, offsetAmount, buyOrSell, true), "sell-total-player", this.replacePlaceholder(playerTotalSellTimes, offsetAmount, buyOrSell, false), "buy-total-server", this.replacePlaceholder(serverTotalBuyTimes, offsetAmount, buyOrSell, true), "sell-total-server", this.replacePlaceholder(serverTotalSellTimes, offsetAmount, buyOrSell, false), "last-buy-player", tempVal3 != null ? tempVal3.getBuyLastTimeName() : "", "last-sell-player", tempVal3 != null ? tempVal3.getSellLastTimeName() : "", "last-buy-server", tempVal4 != null ? tempVal4.getBuyLastTimeName() : "", "last-sell-server", tempVal4 != null ? tempVal4.getSellLastTimeName() : "", "last-reset-buy-player", tempVal3 != null ? tempVal3.getBuyLastResetTimeName() : "", "last-reset-sell-player", tempVal3 != null ? tempVal3.getSellLastResetTimeName() : "", "last-reset-buy-server", tempVal4 != null ? tempVal4.getBuyLastResetTimeName() : "", "last-reset-sell-server", tempVal4 != null ? tempVal4.getSellLastResetTimeName() : "");
            }
            cost = MathUtil.doCalculate(TextUtil.withPAPI(tempVal1, player));
        }
        if (this.singleSection.getString("max-amount") != null && cost.compareTo(maxAmount = new BigDecimal(TextUtil.withPAPI(this.singleSection.getString("max-amount"), player))) > 0) {
            cost = maxAmount;
        }
        if (this.singleSection.getString("min-amount") != null && cost.compareTo(minAmount = new BigDecimal(TextUtil.withPAPI(this.singleSection.getString("min-amount"), player))) < 0) {
            cost = minAmount;
        }
        return cost.setScale(MathUtil.scale, RoundingMode.HALF_UP);
    }

    protected String replacePlaceholder(int baseAmount, int offsetAmount, boolean buyOrSell, boolean placeholderBuyOrSell) {
        if (buyOrSell && placeholderBuyOrSell || !buyOrSell && !placeholderBuyOrSell) {
            return String.valueOf(baseAmount + offsetAmount);
        }
        return String.valueOf(baseAmount);
    }
}

