/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.subobjects;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.objects.items.subobjects.ConditionalPlaceholderType;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ObjectConditionalPlaceholder {
    private final String id;
    private final ConfigurationSection section;
    private final ConfigurationSection valueSection;
    private final ConfigurationSection conditionSection;
    private final ConditionalPlaceholderType mode;

    public ObjectConditionalPlaceholder(String id, ConfigurationSection section) {
        this.id = id;
        this.section = section;
        this.valueSection = section.getConfigurationSection("value");
        this.conditionSection = section.getConfigurationSection("conditions");
        String mode = section.getString("mode", "DEFAULT");
        this.mode = mode.equals("DEFAULT") ? ConditionalPlaceholderType.DEFAULT : (mode.equals("MAX") ? ConditionalPlaceholderType.MAX : ConditionalPlaceholderType.MIN);
        UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded conditional placeholder: " + id + ".yml!");
    }

    public String getID() {
        return this.id;
    }

    public String getValue(Player player) {
        if (this.section == null || this.valueSection == null || this.conditionSection == null) {
            return "";
        }
        Set groupNameSet = this.conditionSection.getKeys(false);
        ArrayList<Double> result = new ArrayList<Double>();
        for (String groupName : groupNameSet) {
            ObjectCondition condition = new ObjectCondition(this.conditionSection.getConfigurationSection(groupName));
            if (!condition.getAllBoolean(new ObjectThingRun(player))) continue;
            if (this.mode.equals((Object)ConditionalPlaceholderType.DEFAULT)) {
                return TextUtil.withPAPI(this.valueSection.getString(groupName, ""), player);
            }
            result.add(this.valueSection.getDouble(groupName, 1.0));
        }
        if (this.mode.equals((Object)ConditionalPlaceholderType.DEFAULT)) {
            return TextUtil.withPAPI(this.valueSection.getString("default", ""), player);
        }
        result.add(this.valueSection.getDouble("default", 1.0));
        if (this.mode.equals((Object)ConditionalPlaceholderType.MIN)) {
            return String.valueOf(Collections.min(result));
        }
        return String.valueOf(Collections.max(result));
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectConditionalPlaceholder) {
            return ((ObjectConditionalPlaceholder)object).getID().equals(this.getID());
        }
        return false;
    }

    public static String getNowValue(String id, Player player) {
        return "ERROR: Free Version";
    }
}

