/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.menus;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.inv.CommonGUI;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.objects.menus.MenuSender;
import cn.superiormc.ultimateshop.objects.menus.MenuType;
import cn.superiormc.ultimateshop.utils.CommandUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ObjectMenu {
    public MenuType type;
    public static Map<String, ObjectMenu> commonMenus = new HashMap<String, ObjectMenu>();
    public static Collection<String> notCommonMenuNames = new HashSet<String>();
    public String fileName;
    private ObjectShop shop = null;
    private ObjectCondition condition;
    private ObjectAction openAction;
    private ObjectAction closeAction;
    public Configuration menuConfigs;
    public Map<Integer, AbstractButton> menuItems = new TreeMap<Integer, AbstractButton>();
    public Map<String, AbstractButton> buttonItems = new HashMap<String, AbstractButton>();
    private boolean useGeyser;
    private boolean dynamicLayout;

    public ObjectMenu(String fileName, ObjectShop shop) {
        this.fileName = fileName;
        this.shop = shop;
        this.type = MenuType.Shop;
        this.initMenu();
        if (!this.dynamicLayout) {
            this.initShopItems(MenuSender.empty);
            this.initButtonItems(MenuSender.empty);
        }
    }

    public ObjectMenu(String fileName, ObjectItem item) {
        this.fileName = fileName;
        this.shop = item.getShopObject();
        this.type = MenuType.More;
        this.initMenu();
        if (!this.dynamicLayout) {
            this.initButtonItems(MenuSender.empty);
        }
    }

    public ObjectMenu(String fileName) {
        this.fileName = fileName;
        this.type = MenuType.Common;
        this.initMenu();
        if (!this.dynamicLayout) {
            this.initButtonItems(MenuSender.empty);
        }
    }

    public MenuType getType() {
        return this.type;
    }

    public void initMenu() {
        if (this.type == MenuType.Common) {
            commonMenus.put(this.fileName, this);
        } else {
            notCommonMenuNames.add(this.fileName);
        }
        File file = new File(String.valueOf(UltimateShop.instance.getDataFolder()) + "/menus/" + this.fileName + ".yml");
        if (!file.exists()) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cError: We can not found your menu file: " + this.fileName + ".yml!");
        } else {
            if (this.type == MenuType.Common) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded menu: " + this.fileName + ".yml!");
            }
            this.menuConfigs = YamlConfiguration.loadConfiguration((File)file);
        }
        if (this.menuConfigs == null) {
            this.condition = new ObjectCondition();
            this.openAction = new ObjectAction();
            this.closeAction = new ObjectAction();
            this.useGeyser = true;
        } else if (this.shop != null) {
            this.condition = new ObjectCondition(this.menuConfigs.getConfigurationSection("conditions"));
            this.openAction = new ObjectAction(this.menuConfigs.getConfigurationSection("open-actions"), this.shop);
            this.closeAction = new ObjectAction(this.menuConfigs.getConfigurationSection("close-actions"));
            this.useGeyser = true;
        } else {
            this.condition = new ObjectCondition(this.menuConfigs.getConfigurationSection("conditions"), this.shop);
            this.openAction = new ObjectAction(this.menuConfigs.getConfigurationSection("open-actions"));
            this.closeAction = new ObjectAction(this.menuConfigs.getConfigurationSection("close-actions"));
            this.useGeyser = this.menuConfigs.getBoolean("bedrock.enabled", true);
        }
        if (this.menuConfigs.getBoolean("dynamic-layout", false)) {
            // empty if block
        }
        this.dynamicLayout = false;
    }

    public void initShopItems(MenuSender menuSender) {
        if (this.menuConfigs == null) {
            return;
        }
        int slot = 0;
        for (String singleLine : this.menuConfigs.getStringList("layout")) {
            int c = 0;
            while (c < singleLine.length()) {
                String id;
                if (singleLine.charAt(c) == '`') {
                    int end = singleLine.indexOf(96, c + 1);
                    if (end == -1) {
                        id = String.valueOf(singleLine.charAt(c));
                        ++c;
                    } else {
                        id = singleLine.substring(c + 1, end);
                        c = end + 1;
                    }
                } else {
                    id = String.valueOf(singleLine.charAt(c));
                    ++c;
                }
                if (!menuSender.isStatic()) {
                    id = TextUtil.withPAPI(id, menuSender.getPlayer());
                }
                if (this.shop.getButton(id) != null) {
                    this.menuItems.put(slot, this.shop.getButton(id));
                } else if (this.shop.getProduct(id) != null) {
                    this.menuItems.put(slot, this.shop.getProduct(id));
                }
                ++slot;
            }
        }
    }

    public void initButtonItems(MenuSender menuSender) {
        if (this.menuConfigs == null) {
            return;
        }
        ConfigurationSection tempVal1 = this.menuConfigs.getConfigurationSection("buttons");
        if (tempVal1 == null) {
            return;
        }
        for (String button : tempVal1.getKeys(false)) {
            if (this.shop == null) {
                this.buttonItems.put(button, new ObjectButton(tempVal1.getConfigurationSection(button)));
                continue;
            }
            this.buttonItems.put(button, new ObjectButton(tempVal1.getConfigurationSection(button), this.shop));
        }
        int slot = 0;
        for (String singleLine : this.menuConfigs.getStringList("layout")) {
            int c = 0;
            while (c < singleLine.length()) {
                AbstractButton buttonObj;
                String id;
                if (singleLine.charAt(c) == '`') {
                    int end = singleLine.indexOf(96, c + 1);
                    if (end == -1) {
                        id = String.valueOf(singleLine.charAt(c));
                        ++c;
                    } else {
                        id = singleLine.substring(c + 1, end);
                        c = end + 1;
                    }
                } else {
                    id = String.valueOf(singleLine.charAt(c));
                    ++c;
                }
                if (!menuSender.isStatic()) {
                    id = TextUtil.withPAPI(id, menuSender.getPlayer());
                }
                if ((buttonObj = this.buttonItems.get(id)) != null) {
                    this.menuItems.put(slot, buttonObj);
                }
                ++slot;
            }
        }
    }

    private void initCustomCommand() {
        String commandName = this.menuConfigs.getString("custom-command.name");
        if (commandName != null && !commandName.isEmpty()) {
            ObjectMenu menu = this;
            BukkitCommand command = new BukkitCommand(commandName){

                public boolean execute(CommandSender sender, String label, String[] args) {
                    if (!(sender instanceof Player)) {
                        LanguageManager.languageManager.sendStringText("error.in-game");
                        return true;
                    }
                    CommonGUI.openGUI((Player)sender, ObjectMenu.this.fileName, false, false);
                    return true;
                }
            };
            command.setDescription(menu.getString("custom-command.description", "UltimateShop Custom Command for " + commandName));
            CommandUtil.registerCustomCommand(command);
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fRegistered custom command for menu: " + this.fileName + ".");
        }
    }

    public String getString(String path, String defaultValue) {
        if (defaultValue == null) {
            return this.menuConfigs.getString(path);
        }
        return this.menuConfigs.getString(path, defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.menuConfigs.getInt(path, defaultValue);
    }

    public Map<Integer, AbstractButton> getMenu(MenuSender menuSender) {
        if (this.dynamicLayout) {
            if (this.type == MenuType.Shop) {
                this.initShopItems(menuSender);
            }
            this.initButtonItems(menuSender);
        }
        return this.menuItems;
    }

    public ObjectCondition getCondition() {
        return this.condition;
    }

    public void doOpenAction(Player player, boolean reopen) {
        if (this.openAction != null) {
            this.openAction.runAllActions(new ObjectThingRun(player, reopen));
        }
    }

    public void doCloseAction(Player player) {
        if (this.closeAction != null) {
            this.closeAction.runAllActions(new ObjectThingRun(player));
        }
    }

    public String getName() {
        return this.fileName;
    }

    public ConfigurationSection getConfig() {
        return this.menuConfigs;
    }

    public boolean isUseGeyser() {
        return this.useGeyser;
    }

    public boolean isDynamicLayout() {
        return this.dynamicLayout;
    }

    protected void parseLayout(List<String> layout, BiConsumer<Integer, String> itemHandler) {
        int slot = 0;
        for (String singleLine : layout) {
            int c = 0;
            while (c < singleLine.length()) {
                String id;
                if (singleLine.charAt(c) == '`') {
                    int end = singleLine.indexOf(96, c + 1);
                    if (end == -1) {
                        id = String.valueOf(singleLine.charAt(c));
                        ++c;
                    } else {
                        id = singleLine.substring(c + 1, end);
                        c = end + 1;
                    }
                } else {
                    id = String.valueOf(singleLine.charAt(c));
                    ++c;
                }
                itemHandler.accept(slot, id);
                ++slot;
            }
        }
    }
}

