/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.utils;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LocateManager;
import cn.superiormc.ultimateshop.methods.Items.DebuildItem;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.MemorySection;
import org.bukkit.inventory.ItemStack;

public class ItemUtil {
    public static String getItemName(ItemStack displayItem) {
        if (displayItem == null || displayItem.getItemMeta() == null) {
            return "";
        }
        if (CommonUtil.getMinorVersion(20, 5) && displayItem.getItemMeta().hasItemName()) {
            return UltimateShop.methodUtil.getItemItemName(displayItem.getItemMeta());
        }
        if (displayItem.getItemMeta().hasDisplayName()) {
            return UltimateShop.methodUtil.getItemName(displayItem.getItemMeta());
        }
        if (LocateManager.enableThis() && LocateManager.locateManager != null) {
            return LocateManager.locateManager.getLocateName(displayItem);
        }
        return ItemUtil.getItemNameWithoutVanilla(displayItem);
    }

    public static String getItemNameWithoutVanilla(ItemStack displayItem) {
        if (displayItem == null || displayItem.getItemMeta() == null) {
            return "";
        }
        if (displayItem.getItemMeta().hasDisplayName()) {
            return UltimateShop.methodUtil.getItemName(displayItem.getItemMeta());
        }
        if (UltimateShop.methodUtil.methodID().equals("paper") && ConfigManager.configManager.getBoolean("display-item.auto-translate-item-name")) {
            return "<lang:" + displayItem.translationKey() + ">";
        }
        StringBuilder result = new StringBuilder();
        for (String word : displayItem.getType().name().toLowerCase().split("_")) {
            if (word.isEmpty()) continue;
            char firstChar = Character.toUpperCase(word.charAt(0));
            String restOfWord = word.substring(1);
            result.append(firstChar).append(restOfWord).append(" ");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static boolean isSameItem(ItemStack item1, ItemStack item2) {
        if (ConfigManager.configManager.getStringOrDefault("sell-mode", "sell.sell-method", "Bukkit").equals("Bukkit")) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fItem in player inventory: " + String.valueOf(item1));
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fItem in shop: " + String.valueOf(item2));
            }
            return item1.isSimilar(item2);
        }
        Map item1Result = DebuildItem.debuildItem(item1, (ConfigurationSection)new MemoryConfiguration()).getValues(true);
        Map item2Result = DebuildItem.debuildItem(item2, (ConfigurationSection)new MemoryConfiguration()).getValues(true);
        if (ConfigManager.configManager.getBoolean("sell.item-format.require-same-key")) {
            for (String key : item1Result.keySet()) {
                if (ItemUtil.canIgnore(key) || item2Result.containsKey(key)) continue;
                return false;
            }
        }
        for (String key : item2Result.keySet()) {
            String tempVal2;
            String tempVal1;
            if (ItemUtil.canIgnore(key)) continue;
            Object object = item1Result.get(key);
            if (object == null) {
                return false;
            }
            if (object instanceof MemorySection || object.equals(item2Result.get(key)) || object instanceof String && item2Result.get(key) instanceof String && (tempVal1 = (String)object).equalsIgnoreCase(tempVal2 = (String)item2Result.get(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean canIgnore(String key) {
        if (key == null) {
            return true;
        }
        if (key.equals("amount")) {
            return true;
        }
        for (String tempVal1 : ConfigManager.configManager.getStringListOrDefault("sell.ignore-item-format-key", "sell.item-format.ignore-key")) {
            if (!tempVal1.equals(key) && !key.startsWith(tempVal1 + ".")) continue;
            return true;
        }
        return false;
    }
}

