/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.biome;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.stln.magitech.Magitech;
import net.stln.magitech.biome.MistjadeForestRegion;
import net.stln.magitech.biome.ScorchedPlainsRegion;
import net.stln.magitech.biome.ScorchedSoilSurfaceRule;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class BiomeInit {
    public static final ResourceKey<Biome> MISTJADE_FOREST = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Magitech.id("mistjade_forest"));
    public static final ResourceKey<Biome> SCORCHED_PLAINS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Magitech.id("scorched_plains"));
    public static final TagKey<Biome> HAS_CELIFERN_FOREST = BiomeInit.createTagKey("has_celifern_forest");
    public static final TagKey<Biome> HAS_CHARCOAL_BIRCH_FOREST = BiomeInit.createTagKey("has_charcoal_birch_forest");
    public static final TagKey<Biome> HAS_MANA_BERRY_BUSH = BiomeInit.createTagKey("has_mana_berry_bush");
    public static final TagKey<Biome> HAS_MISTALIA_PETALS = BiomeInit.createTagKey("has_mistalia_petals");
    public static final TagKey<Biome> IS_SCORCHED = BiomeInit.createTagKey("is_scorched");

    private static TagKey<Biome> createTagKey(String path) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Magitech.id(path));
    }

    public static void registerBiomeRegions(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Regions.register((Region)new MistjadeForestRegion(Magitech.id("mistjade_forest"), 2));
            Regions.register((Region)new ScorchedPlainsRegion(Magitech.id("scorched_plains"), 2));
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"magitech", (SurfaceRules.RuleSource)ScorchedSoilSurfaceRule.makeRule());
        });
    }
}

