/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.block.block_entity.AthanorPillarBlockEntity;

public class AthanorPillarBlock
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.box((double)2.0, (double)4.0, (double)6.0, (double)4.0, (double)6.0, (double)10.0), Block.box((double)12.0, (double)4.0, (double)6.0, (double)14.0, (double)6.0, (double)10.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)10.0, (double)4.0), Block.box((double)0.0, (double)8.0, (double)12.0, (double)4.0, (double)10.0, (double)16.0), Block.box((double)12.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)4.0), Block.box((double)12.0, (double)8.0, (double)12.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)6.0, (double)4.0, (double)2.0, (double)10.0, (double)6.0, (double)4.0), Block.box((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)6.0, (double)14.0)});
    public static final MapCodec<AthanorPillarBlock> CODEC = AthanorPillarBlock.simpleCodec(AthanorPillarBlock::new);

    public AthanorPillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AthanorPillarBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return this.createTicker(level, blockEntityType, BlockInit.ATHANOR_PILLAR_ENTITY.get());
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AthanorPillarBlockEntity) {
            AthanorPillarBlockEntity pylonBlockEntity = (AthanorPillarBlockEntity)blockEntity;
            pylonBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, WATERLOGGED});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AthanorPillarBlockEntity) {
            AthanorPillarBlockEntity pylonBlockEntity = (AthanorPillarBlockEntity)blockEntity;
            if (pylonBlockEntity.inventory.getStackInSlot(0).isEmpty() && !stack.isEmpty()) {
                pylonBlockEntity.inventory.insertItem(0, stack.copy(), false);
                stack.shrink(1);
                level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 2.0f);
            } else if (stack.isEmpty()) {
                stackOnPedestal = pylonBlockEntity.inventory.extractItem(0, 1, false);
                player.setItemInHand(InteractionHand.MAIN_HAND, stackOnPedestal);
                pylonBlockEntity.clearContents();
                level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                stackOnPedestal = pylonBlockEntity.inventory.extractItem(0, 1, false);
                if (stack.getCount() == 1) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, stackOnPedestal);
                } else {
                    player.addItem(stackOnPedestal);
                }
                pylonBlockEntity.clearContents();
                pylonBlockEntity.inventory.insertItem(0, stack.copy(), false);
                stack.shrink(1);
                level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends AthanorPillarBlockEntity> clientType) {
        return AthanorPillarBlock.createTickerHelper(serverType, clientType, (pLevel1, pPos, pState1, pBlockEntity) -> {
            if (pLevel1.isClientSide) {
                pBlockEntity.clientTick(pLevel1, pPos, pState1, (AthanorPillarBlockEntity)pBlockEntity);
            } else {
                pBlockEntity.serverTick(pLevel1, pPos, pState1, (AthanorPillarBlockEntity)pBlockEntity);
            }
        });
    }
}

