/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.block.CrystalClusterBlock;
import net.stln.magitech.particle.particle_option.UnstableSquareParticleEffect;
import org.joml.Vector3f;

public class RedstoneCrystalClusterBlock
extends CrystalClusterBlock {
    public RedstoneCrystalClusterBlock(IntProvider xpRange, BlockBehaviour.Properties properties) {
        super(xpRange, properties);
    }

    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 15;
    }

    protected int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.getValue((Property)FACING) == direction ? 15 : 0;
    }

    private void updateNeighbours(BlockState state, Level level, BlockPos pos) {
        level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.updateNeighbours(state, (Level)level, pos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((long)level.random.nextInt(200) <= level.getGameTime() % 200L) {
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
            double d0 = vec3.x + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
            double d1 = vec3.y + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
            double d2 = vec3.z + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
            double d3 = Mth.nextDouble((RandomSource)level.random, (double)-0.2, (double)0.2);
            double d4 = Mth.nextDouble((RandomSource)level.random, (double)-0.2, (double)0.2);
            double d5 = Mth.nextDouble((RandomSource)level.random, (double)-0.2, (double)0.2);
            level.addParticle((ParticleOptions)new UnstableSquareParticleEffect(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), 1.0f, 5, 0.0f), d0, d1, d2, d3, d4, d5);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            this.updateNeighbours(state, level, pos);
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }
}

