/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NyliumBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;
import net.stln.magitech.block.BlockInit;

public class ScorchedGrassSoilBlock
extends Block {
    public static final MapCodec<NyliumBlock> CODEC = ScorchedGrassSoilBlock.simpleCodec(NyliumBlock::new);

    public ScorchedGrassSoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean canBeGrass(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = reader.getBlockState(blockpos);
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)reader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)reader, blockpos));
        return i < reader.getMaxLightLevel();
    }

    public MapCodec<NyliumBlock> codec() {
        return CODEC;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!ScorchedGrassSoilBlock.canBeGrass(state, (LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, ((Block)BlockInit.SCORCHED_SOIL.get()).defaultBlockState());
        }
    }
}

