/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.stln.magitech.block.block_entity.ToolHangerBlockEntity;
import net.stln.magitech.item.ItemTagKeys;
import net.stln.magitech.util.VoxelShapeUtil;

public class ToolHangerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)12.0, (double)6.0, (double)16.0, (double)16.0, (double)14.0));
    public static final VoxelShape SHAPE_SOUTH = VoxelShapeUtil.rotateShape(SHAPE_NORTH, Direction.NORTH, Direction.SOUTH);
    public static final VoxelShape SHAPE_EAST = VoxelShapeUtil.rotateShape(SHAPE_NORTH, Direction.NORTH, Direction.EAST);
    public static final VoxelShape SHAPE_WEST = VoxelShapeUtil.rotateShape(SHAPE_NORTH, Direction.NORTH, Direction.WEST);
    public static final MapCodec<ToolHangerBlock> CODEC = ToolHangerBlock.simpleCodec(ToolHangerBlock::new);

    public ToolHangerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static Vec3 getToolRenderPos(int slot, BlockState blockState) {
        Vec3 offset = new Vec3(-0.3, 0.0, -0.3);
        offset = offset.add(0.3 * (double)slot, 0.0, 0.15 * (double)slot);
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        double rotation = Math.toRadians(direction.toYRot());
        return offset.yRot((float)(-rotation));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(state.getValue((Property)FACING)));
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ToolHangerBlockEntity(blockPos, blockState);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof ToolHangerBlockEntity) {
            ToolHangerBlockEntity pylonBlockEntity = (ToolHangerBlockEntity)blockEntity;
            pylonBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ToolHangerBlockEntity) {
            ToolHangerBlockEntity toolHangerBlockEntity = (ToolHangerBlockEntity)entity;
            ItemStack itemInHand = player.getItemInHand(hand);
            if (itemInHand.isEmpty() || itemInHand.getTags().anyMatch(itemTagKey -> itemTagKey.equals(ItemTagKeys.TOOLS))) {
                toolHangerBlockEntity.addItem(player, itemInHand, this.getClickedSlot(hitResult, state));
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    private int getClickedSlot(BlockHitResult hitResult, BlockState blockState) {
        Vec3 hitVec = hitResult.getLocation().subtract((double)hitResult.getBlockPos().getX(), (double)hitResult.getBlockPos().getY(), (double)hitResult.getBlockPos().getZ()).add(-0.5, -0.5, -0.5);
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        double rotation = Math.toRadians(direction.toYRot());
        Vec3 localHitVec = hitVec.yRot((float)rotation);
        double x = localHitVec.x;
        if (x < -0.15) {
            return 0;
        }
        if (x < 0.15) {
            return 1;
        }
        return 2;
    }
}

