/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block.block_entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.element.Element;
import org.jetbrains.annotations.Nullable;

public abstract class ManaContainerBlockEntity
extends BlockEntity {
    int mana = 0;
    int maxMana = 100;
    int barGaugeLength = 30;

    public ManaContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.mana = tag.getInt("Mana");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("Mana", this.mana);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = super.getUpdateTag(pRegistries);
        tag.putInt("Mana", this.mana);
        return tag;
    }

    public void addMana(int value) {
        this.mana += value;
        this.mana = Math.clamp((long)this.mana, 0, this.maxMana);
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void subMana(int value) {
        this.mana -= value;
        this.mana = Math.clamp((long)this.mana, 0, this.maxMana);
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public List<Component> getManaInfo() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)this.getBlockState().getBlock().getName());
        list.add((Component)Component.empty());
        double chargedRatio = (double)this.mana / (double)this.maxMana;
        int litBarGaugeLength = (int)(chargedRatio * (double)this.barGaugeLength);
        list.add((Component)Component.translatable((String)"tooltip.magitech.block.mana_capacity").append(": ").withColor(0x808080));
        list.add((Component)Component.literal((String)"|".repeat(litBarGaugeLength)).withColor(Element.NONE.getSpellColor()).append((Component)Component.literal((String)"|".repeat(this.barGaugeLength - litBarGaugeLength)).withColor(Element.NONE.getSpellDark())));
        list.add((Component)Component.literal((String)String.valueOf(this.mana)).withColor(Element.NONE.getSpellColor()).append((Component)Component.literal((String)" / ").withColor(0x808080)).append((Component)Component.literal((String)String.valueOf(this.maxMana)).withColor(Element.NONE.getSpellDark())));
        return list;
    }

    public List<Component> getSimpleManaInfo() {
        ArrayList<Component> list = new ArrayList<Component>();
        double chargedRatio = (double)this.mana / (double)this.maxMana;
        int litBarGaugeLength = (int)(chargedRatio * (double)this.barGaugeLength);
        list.add((Component)Component.translatable((String)"tooltip.magitech.block.mana_capacity").append(": ").withColor(0x808080));
        list.add((Component)Component.literal((String)"|".repeat(litBarGaugeLength)).withColor(Element.NONE.getSpellColor()).append((Component)Component.literal((String)"|".repeat(this.barGaugeLength - litBarGaugeLength)).withColor(Element.NONE.getSpellDark())));
        list.add((Component)Component.literal((String)String.valueOf(this.mana)).withColor(Element.NONE.getSpellColor()).append((Component)Component.literal((String)" / ").withColor(0x808080)).append((Component)Component.literal((String)String.valueOf(this.maxMana)).withColor(Element.NONE.getSpellDark())));
        return list;
    }

    public int getMana() {
        return this.mana;
    }

    public void setMana(int value) {
        this.mana = value;
        this.mana = Math.clamp((long)this.mana, 0, this.maxMana);
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public int getMaxMana() {
        return this.maxMana;
    }

    public boolean isFull() {
        return this.mana == this.maxMana;
    }
}

