/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block.block_entity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.block.ZardiusCrucibleBlock;
import net.stln.magitech.particle.particle_option.SquareParticleEffect;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.ZardiusCrucibleRecipe;
import net.stln.magitech.recipe.input.CrucibleRecipeInput;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ZardiusCrucibleBlockEntity
extends BlockEntity {
    public final ItemStackHandler inventory = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            ZardiusCrucibleBlockEntity.this.setChanged();
            if (!ZardiusCrucibleBlockEntity.this.level.isClientSide()) {
                ZardiusCrucibleBlockEntity.this.level.sendBlockUpdated(ZardiusCrucibleBlockEntity.this.getBlockPos(), ZardiusCrucibleBlockEntity.this.getBlockState(), ZardiusCrucibleBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    public final FluidTank fluidTank = new FluidTank(2000){

        protected void onContentsChanged() {
            ZardiusCrucibleBlockEntity.this.setChanged();
            if (!ZardiusCrucibleBlockEntity.this.level.isClientSide()) {
                ZardiusCrucibleBlockEntity.this.level.sendBlockUpdated(ZardiusCrucibleBlockEntity.this.getBlockPos(), ZardiusCrucibleBlockEntity.this.getBlockState(), ZardiusCrucibleBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    public int craftingTime = 0;
    public int maxCraftingTime = 200;
    public FluidStack oldFluidStack = FluidStack.EMPTY;
    public int tickCounter = 0;
    private double fluidAnimBefore = 0.0;
    private double fluidAnimAfter = 0.0;
    private float startMarker = 0.0f;
    private double lastRenderValue = 0.0;

    public ZardiusCrucibleBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockInit.ZARDIUS_CRUCIBLE_ENTITY.get(), pos, blockState);
    }

    public NonNullList<ItemStack> getRenderStack() {
        NonNullList stack = NonNullList.create();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            stack.add((Object)this.inventory.getStackInSlot(i));
        }
        if (stack.isEmpty()) {
            stack.add((Object)ItemStack.EMPTY);
        }
        return stack;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        ZardiusCrucibleBlock crucibleBlock;
        this.addDroppedItem();
        List<ItemStack> stacks = IntStream.rangeClosed(0, this.inventory.getSlots() - 1).mapToObj(arg_0 -> ((ItemStackHandler)this.inventory).getStackInSlot(arg_0)).toList();
        CrucibleRecipeInput input = new CrucibleRecipeInput(stacks, this.fluidTank.getFluid());
        level.getRecipeManager().getRecipeFor(RecipeInit.ZARDIUS_CRUCIBLE_TYPE.get(), (RecipeInput)input, level).map(RecipeHolder::value).ifPresent(recipe -> this.processRecipe(level, pos, state, (ZardiusCrucibleRecipe)recipe, input));
        Block block = state.getBlock();
        if (block instanceof ZardiusCrucibleBlock && (crucibleBlock = (ZardiusCrucibleBlock)block).isOnFire(state, level, pos)) {
            this.playBoilSound(level, pos, state);
        }
    }

    private void processRecipe(Level level, BlockPos pos, BlockState state, ZardiusCrucibleRecipe recipe, CrucibleRecipeInput input) {
        BlockState newState;
        ZardiusCrucibleBlock crucibleBlock;
        Block block = state.getBlock();
        if (block instanceof ZardiusCrucibleBlock && (crucibleBlock = (ZardiusCrucibleBlock)block).isOnFire(state, level, pos)) {
            if (this.inventory.getStackInSlot(0).getCount() >= 2) {
                return;
            }
            int requiredAmount = recipe.fluidIngredient().amount();
            boolean canProcessFluid = recipe.resultFluid().map(fluidStack -> {
                if (this.fluidTank.getFluidAmount() != fluidStack.getAmount()) {
                    return false;
                }
                return this.fluidTank.drain(requiredAmount, IFluidHandler.FluidAction.SIMULATE).getAmount() == requiredAmount;
            }).orElseGet(() -> this.fluidTank.drain(requiredAmount, IFluidHandler.FluidAction.SIMULATE).getAmount() >= requiredAmount);
            if (canProcessFluid) {
                if (this.craftingTime < this.maxCraftingTime) {
                    ++this.craftingTime;
                    newState = (BlockState)state.setValue((Property)ZardiusCrucibleBlock.LIT, (Comparable)Boolean.valueOf(true));
                } else {
                    ItemStack result = recipe.assemble(input, (HolderLookup.Provider)level.registryAccess());
                    this.fluidTank.drain(requiredAmount, IFluidHandler.FluidAction.EXECUTE);
                    recipe.resultFluid().ifPresent(fluidStack -> this.fluidTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE));
                    this.clearContents();
                    this.addItemStack(result, result.getCount());
                    this.craftingTime = 0;
                    level.playSound(null, pos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 0.6f + level.random.nextFloat() * 0.8f);
                    newState = (BlockState)state.setValue((Property)ZardiusCrucibleBlock.LIT, (Comparable)Boolean.valueOf(false));
                }
            } else {
                this.craftingTime = 0;
                newState = (BlockState)state.setValue((Property)ZardiusCrucibleBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
        } else {
            this.craftingTime = 0;
            newState = (BlockState)state.setValue((Property)ZardiusCrucibleBlock.LIT, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, newState, 3);
        this.setChanged();
    }

    private void playBoilSound(Level level, BlockPos pPos, BlockState pState) {
        RandomSource random = level.random;
        if (this.fluidTank.getFluid().is(Tags.Fluids.LAVA)) {
            if (((Boolean)pState.getValue((Property)ZardiusCrucibleBlock.LIT)).booleanValue() && (double)random.nextFloat() > 0.95) {
                level.playSound(null, pPos, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.5f, 0.6f + random.nextFloat() * 0.8f);
            }
            if ((double)random.nextFloat() > 0.99) {
                level.playSound(null, pPos, SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.5f, 0.6f + random.nextFloat() * 0.8f);
            }
        } else if (!this.fluidTank.isEmpty()) {
            if (((Boolean)pState.getValue((Property)ZardiusCrucibleBlock.LIT)).booleanValue()) {
                if ((double)random.nextFloat() > 0.8) {
                    level.playSound(null, pPos, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, 5.0f, 0.4f + random.nextFloat());
                }
                if ((double)random.nextFloat() > 0.7) {
                    level.playSound(null, pPos, SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON, SoundSource.BLOCKS, 1.0f, 0.6f + random.nextFloat() * 0.8f);
                }
            }
            if ((double)random.nextFloat() > 0.95) {
                level.playSound(null, pPos, SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON, SoundSource.BLOCKS, 1.0f, 0.6f + random.nextFloat() * 0.8f);
            }
        }
    }

    public void clientTick(Level level, BlockPos pPos, BlockState pState) {
        ++this.tickCounter;
        if (this.tickCounter > 2000 && this.startMarker > 1000.0f && this.startMarker < (float)(this.tickCounter - 200)) {
            this.tickCounter -= 1000;
            this.startMarker -= 1000.0f;
        }
        if (((Boolean)pState.getValue((Property)ZardiusCrucibleBlock.LIT)).booleanValue()) {
            float height = (float)this.lastRenderValue / (float)this.fluidTank.getCapacity() * 0.75f + 0.2f;
            for (int i = 0; i < 10; ++i) {
                level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.5f, 1.0f, 0.5f), new Vector3f(0.5f, 0.5f, 1.0f), 1.5f, Mth.randomBetweenInclusive((RandomSource)level.random, (int)5, (int)10), Mth.randomBetween((RandomSource)level.random, (float)-0.05f, (float)0.05f)), (double)pPos.getX() + 0.5 + (double)Mth.randomBetween((RandomSource)level.random, (float)-0.375f, (float)0.375f), (double)((float)pPos.getY() + height), (double)pPos.getZ() + 0.5 + (double)Mth.randomBetween((RandomSource)level.random, (float)-0.375f, (float)0.375f), (double)Mth.randomBetween((RandomSource)level.random, (float)-0.075f, (float)0.075f), (double)Mth.randomBetween((RandomSource)level.random, (float)0.05f, (float)0.2f), (double)Mth.randomBetween((RandomSource)level.random, (float)-0.075f, (float)0.075f));
                level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(1.0f, 0.5f, 1.0f), new Vector3f(0.5f, 1.0f, 1.0f), 1.5f, Mth.randomBetweenInclusive((RandomSource)level.random, (int)5, (int)10), Mth.randomBetween((RandomSource)level.random, (float)-0.05f, (float)0.05f)), (double)pPos.getX() + 0.5 + (double)Mth.randomBetween((RandomSource)level.random, (float)-0.375f, (float)0.375f), (double)((float)pPos.getY() + height), (double)pPos.getZ() + 0.5 + (double)Mth.randomBetween((RandomSource)level.random, (float)-0.375f, (float)0.375f), (double)Mth.randomBetween((RandomSource)level.random, (float)-0.075f, (float)0.075f), (double)Mth.randomBetween((RandomSource)level.random, (float)0.05f, (float)0.2f), (double)Mth.randomBetween((RandomSource)level.random, (float)-0.075f, (float)0.075f));
            }
        }
    }

    private void addDroppedItem() {
        List<ItemEntity> itemList = this.getDroppedItem();
        if (!itemList.isEmpty()) {
            for (ItemEntity itemEntity : itemList) {
                ItemStack stack = itemEntity.getItem();
                if (!this.addItemStack(stack, 1)) continue;
                itemEntity.setItem(stack);
                this.setChanged();
            }
        }
    }

    private List<ItemEntity> getDroppedItem() {
        return new ArrayList<ItemEntity>(this.level.getEntitiesOfClass(ItemEntity.class, new AABB((double)this.worldPosition.getX() + 0.125, (double)this.worldPosition.getY() + 0.1875, (double)this.worldPosition.getZ() + 0.125, (double)this.worldPosition.getX() + 0.875, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.875), EntitySelector.ENTITY_STILL_ALIVE));
    }

    public void addItem(Player player, ItemStack pItemStack, int count) {
        int i;
        boolean hasSingleItems = true;
        for (i = 0; i < 8; ++i) {
            if (this.inventory.getStackInSlot(i).getCount() <= 1) continue;
            hasSingleItems = false;
            break;
        }
        if (pItemStack.isEmpty() || !hasSingleItems) {
            for (i = 0; i < 8; ++i) {
                ItemEntity itementity;
                if (this.inventory.getStackInSlot(7 - i).isEmpty()) continue;
                ItemStack removeStack = this.inventory.getStackInSlot(7 - i);
                player.addItem(removeStack);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, 2.0f);
                if (!removeStack.isEmpty() && (itementity = player.drop(removeStack, false)) != null) {
                    itementity.setNoPickUpDelay();
                    itementity.setTarget(player.getUUID());
                }
                break;
            }
        } else if (!player.isCrouching() && pItemStack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
            IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)pItemStack.split(1).getCapability(Capabilities.FluidHandler.ITEM);
            boolean isEmpty = true;
            for (int i2 = 0; i2 < iFluidHandlerItem.getTanks(); ++i2) {
                if (iFluidHandlerItem.getFluidInTank(i2).isEmpty()) continue;
                isEmpty = false;
            }
            Integer emptyOrSameSlot = this.getItemFluidEmptyOrSameSlot(iFluidHandlerItem, this.fluidTank.getFluid().getFluid());
            if (!this.fluidTank.isEmpty() && isEmpty && emptyOrSameSlot != null && iFluidHandlerItem.isFluidValid(emptyOrSameSlot.intValue(), this.fluidTank.getFluid())) {
                this.playFluidDrainSound(this.fluidTank, iFluidHandlerItem);
                FluidStack stack = this.fluidTank.drain(Math.min(iFluidHandlerItem.getTankCapacity(emptyOrSameSlot.intValue()) - iFluidHandlerItem.getFluidInTank(emptyOrSameSlot.intValue()).getAmount(), 1000), IFluidHandler.FluidAction.EXECUTE);
                iFluidHandlerItem.fill(new FluidStack(stack.getFluid(), stack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
            } else if (this.hasSameFluidOrEmpty(this.fluidTank, iFluidHandlerItem)) {
                this.playFluidFillSound(this.fluidTank, iFluidHandlerItem);
                int drainAmount = Math.min(this.getItemFluidStack(iFluidHandlerItem).getAmount(), 1000);
                if (this.fluidTank.getFluidAmount() + drainAmount <= this.fluidTank.getCapacity()) {
                    FluidStack stack = !player.getAbilities().instabuild ? iFluidHandlerItem.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE) : iFluidHandlerItem.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
                    this.fluidTank.fill(new FluidStack(stack.getFluid(), stack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            if (pItemStack.isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, iFluidHandlerItem.getContainer());
            } else {
                player.addItem(iFluidHandlerItem.getContainer());
            }
        } else {
            this.addItemStack(pItemStack, 1);
        }
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    private void playFluidFillSound(FluidTank fluidTank, IFluidHandlerItem iFluidHandlerItem) {
        boolean isEmpty = true;
        for (int i = 0; i < iFluidHandlerItem.getTanks(); ++i) {
            if (iFluidHandlerItem.getFluidInTank(i).isEmpty()) continue;
            isEmpty = false;
        }
        if (fluidTank.getSpace() != 0 && !isEmpty && this.hasSameFluidOrEmpty(fluidTank, iFluidHandlerItem)) {
            if ((!fluidTank.isEmpty() ? fluidTank.getFluid() : this.getItemFluidStack(iFluidHandlerItem)).is(Tags.Fluids.LAVA)) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.PLAYERS);
            } else {
                this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS);
            }
        }
    }

    private void playFluidDrainSound(FluidTank fluidTank, IFluidHandlerItem iFluidHandlerItem) {
        boolean isMax = true;
        for (int i = 0; i < iFluidHandlerItem.getTanks(); ++i) {
            if (iFluidHandlerItem.getFluidInTank(i).getAmount() == iFluidHandlerItem.getTankCapacity(i)) continue;
            isMax = false;
        }
        if (!fluidTank.isEmpty() && !isMax && this.hasSameFluidOrEmpty(fluidTank, iFluidHandlerItem)) {
            if ((!fluidTank.isEmpty() ? fluidTank.getFluid() : this.getItemFluidStack(iFluidHandlerItem)).is(Tags.Fluids.LAVA)) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_FILL_LAVA, SoundSource.PLAYERS);
            } else {
                this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_FILL, SoundSource.PLAYERS);
            }
        }
    }

    private boolean hasSameFluidOrEmpty(FluidTank fluidTank, IFluidHandlerItem iFluidHandlerItem) {
        FluidStack itemFluid = this.getItemFluidStack(iFluidHandlerItem);
        if (fluidTank.isEmpty() || itemFluid.isEmpty()) {
            return true;
        }
        return FluidStack.isSameFluid((FluidStack)fluidTank.getFluid(), (FluidStack)itemFluid);
    }

    private FluidStack getItemFluidStack(IFluidHandlerItem iFluidHandlerItem) {
        FluidStack itemFluid = FluidStack.EMPTY;
        for (int i = 0; i < iFluidHandlerItem.getTanks(); ++i) {
            if (iFluidHandlerItem.getFluidInTank(i).isEmpty()) continue;
            itemFluid = iFluidHandlerItem.getFluidInTank(i);
            break;
        }
        return itemFluid;
    }

    private Integer getItemFluidEmptyOrSameSlot(IFluidHandlerItem iFluidHandlerItem, Fluid fluid) {
        Integer slot = null;
        for (int i = 0; i < iFluidHandlerItem.getTanks(); ++i) {
            if (!iFluidHandlerItem.getFluidInTank(i).isEmpty() && !iFluidHandlerItem.getFluidInTank(i).is(fluid)) continue;
            slot = i;
            break;
        }
        return slot;
    }

    private boolean addItemStack(ItemStack pItemStack, int count) {
        for (int i = 0; i < 8; ++i) {
            if (!this.inventory.getStackInSlot(i).isEmpty()) continue;
            this.inventory.setStackInSlot(i, pItemStack.split(count));
            this.setChanged();
            return true;
        }
        return false;
    }

    public void clearContents() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            this.setChanged();
        }
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public double getFluidAnim(ZardiusCrucibleBlockEntity blockEntity, float partialTicks) {
        double duration;
        double elapsed;
        float time = (float)this.tickCounter + partialTicks;
        int currentAmount = blockEntity.fluidTank.getFluidAmount();
        if (this.fluidAnimAfter != (double)currentAmount) {
            this.fluidAnimBefore = this.lastRenderValue;
            this.fluidAnimAfter = currentAmount;
            this.startMarker = time;
        }
        if ((elapsed = (double)(time - this.startMarker)) >= (duration = 15.0)) {
            this.lastRenderValue = this.fluidAnimAfter;
            return this.fluidAnimAfter;
        }
        double t = elapsed / duration;
        double interp = -0.5 * Math.pow(t, 3.0) + 1.5 * t;
        this.lastRenderValue = this.fluidAnimBefore * (1.0 - interp) + this.fluidAnimAfter * interp;
        return this.lastRenderValue;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        this.fluidTank.writeToNBT(registries, tag);
        tag.putInt("crafting_time", this.craftingTime);
        tag.putInt("max_crafting_time", this.maxCraftingTime);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.fluidTank.readFromNBT(registries, tag);
        this.craftingTime = tag.getInt("crafting_time");
        this.maxCraftingTime = tag.getInt("max_crafting_time");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

