/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.compat.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.stln.magitech.Magitech;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.compat.jei.AbstractMagitechRecipeCategory;
import net.stln.magitech.element.Element;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.recipe.AthanorPillarInfusionRecipe;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.ToolMaterialRecipe;
import net.stln.magitech.util.ClientHelper;
import net.stln.magitech.util.RenderHelper;
import org.jetbrains.annotations.NotNull;

public class AthanorPillarInfusionRecipeCategory
extends AbstractMagitechRecipeCategory<AthanorPillarInfusionRecipe> {
    public static final ResourceLocation UID = Magitech.id("recipe.magitech.athanor_pillar_infusion");
    public static final ResourceLocation TEXTURE = Magitech.id("textures/gui/jei_widgets.png");
    public static final RecipeType<AthanorPillarInfusionRecipe> ATHANOR_PILLAR_INFUSION_RECIPE_TYPE = new RecipeType(UID, AthanorPillarInfusionRecipe.class);

    public AthanorPillarInfusionRecipeCategory(IDrawable icon) {
        super(icon);
    }

    public AthanorPillarInfusionRecipeCategory(IGuiHelper helper) {
        this(helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(BlockInit.ATHANOR_PILLAR)));
    }

    @NotNull
    public RecipeType<AthanorPillarInfusionRecipe> getRecipeType() {
        return ATHANOR_PILLAR_INFUSION_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"recipe.magitech.athanor_pillar_infusion");
    }

    public void draw(@NotNull AthanorPillarInfusionRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        guiGraphics.blit(TEXTURE, 54, 54, 0, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 36, 36, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 72, 72, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 72, 36, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 36, 72, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 54, 18, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 54, 90, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 18, 54, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 90, 54, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 0, 0, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 108, 108, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 108, 0, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 0, 108, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 130, 58, 0, 18, 21, 10);
        guiGraphics.blit(TEXTURE, 155, 54, 36, 0, 18, 18);
        RenderHelper.renderFramedText(guiGraphics, Minecraft.getInstance().font, Component.translatable((String)"recipe.magitech.required_mana").append(": " + recipe.getMana() / 5 + " x 5").getString(), 0, 128, Element.NONE);
    }

    public int getWidth() {
        return 173;
    }

    public int getHeight() {
        return 136;
    }

    @Override
    protected void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull AthanorPillarInfusionRecipe recipe, @NotNull IFocusGroup focuses, @NotNull RecipeManager recipeManager, @NotNull RegistryAccess access) {
        List<ToolMaterialRecipe> materialRecipes = ClientHelper.getAllRecipes(RecipeInit.TOOL_MATERIAL_TYPE);
        List<ToolMaterial> materials = materialRecipes.stream().map(ToolMaterialRecipe::getToolMaterial).toList();
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        builder.addSlot(RecipeIngredientRole.INPUT, 55, 55).addItemStack(recipe.getBase());
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 37).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 0));
        builder.addSlot(RecipeIngredientRole.INPUT, 73, 73).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 1));
        builder.addSlot(RecipeIngredientRole.INPUT, 73, 37).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 2));
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 73).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 3));
        builder.addSlot(RecipeIngredientRole.INPUT, 55, 19).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 4));
        builder.addSlot(RecipeIngredientRole.INPUT, 55, 91).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 5));
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 55).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 6));
        builder.addSlot(RecipeIngredientRole.INPUT, 91, 55).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 7));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 8));
        builder.addSlot(RecipeIngredientRole.INPUT, 109, 109).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 9));
        builder.addSlot(RecipeIngredientRole.INPUT, 109, 1).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 10));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 109).addIngredients(this.getOrDefault((List<Ingredient>)ingredients, 11));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 156, 55).addItemStack(recipe.getResultItem((HolderLookup.Provider)access));
    }

    private Ingredient getOrDefault(List<Ingredient> ingredients, int index) {
        if (index < ingredients.size()) {
            return ingredients.get(index);
        }
        return Ingredient.EMPTY;
    }
}

