/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.stln.magitech.Magitech;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.compat.jei.AbstractMagitechRecipeCategory;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.MaterialComponent;
import net.stln.magitech.item.component.PartMaterialComponent;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.recipe.ToolAssemblyRecipe;
import net.stln.magitech.util.ClientHelper;
import org.jetbrains.annotations.NotNull;

public class ToolAssemblyRecipeCategory
extends AbstractMagitechRecipeCategory<ToolAssemblyRecipe> {
    public static final ResourceLocation UID = Magitech.id("tool_assembly");
    public static final ResourceLocation TEXTURE = Magitech.id("textures/gui/jei_widgets.png");
    public static final RecipeType<ToolAssemblyRecipe> TOOL_ASSEMBLY_RECIPE_TYPE = new RecipeType(UID, ToolAssemblyRecipe.class);
    private static final Random RANDOM = new Random();

    public ToolAssemblyRecipeCategory(IDrawable icon) {
        super(icon);
    }

    public ToolAssemblyRecipeCategory(IGuiHelper helper) {
        this(helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(BlockInit.ASSEMBLY_WORKBENCH)));
    }

    @NotNull
    public RecipeType<ToolAssemblyRecipe> getRecipeType() {
        return TOOL_ASSEMBLY_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"recipe.magitech.tool_assembly");
    }

    public void draw(@NotNull ToolAssemblyRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int partCount = recipe.getIngredients().size();
        for (int i = 0; i < partCount; ++i) {
            int y;
            int x;
            if (partCount <= 3) {
                int totalWidth = partCount * 18;
                int startX = 19 + (54 - totalWidth) / 2;
                x = startX + i * 18;
                y = 13;
            } else if (partCount == 4) {
                row = i / 2;
                col = i % 2;
                x = 19 + col * 18 + 9;
                y = 4 + row * 18;
            } else {
                row = i / 3;
                col = i % 3;
                x = 19 + col * 18;
                y = 4 + row * 18;
            }
            guiGraphics.blit(TEXTURE, x, y, 0, 0, 18, 18);
        }
        guiGraphics.blit(TEXTURE, 76, 17, 0, 18, 21, 10);
        guiGraphics.blit(TEXTURE, 101, 13, 36, 0, 18, 18);
    }

    public int getWidth() {
        return 137;
    }

    public int getHeight() {
        return 44;
    }

    @Override
    protected void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ToolAssemblyRecipe recipe, @NotNull IFocusGroup focuses, @NotNull RecipeManager recipeManager, @NotNull RegistryAccess access) {
        List<ToolMaterial> materials = ClientHelper.getAllCraftableMaterials();
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < 200; ++i) {
            ArrayList parts = new ArrayList();
            ArrayList<ToolMaterial> toolMaterials = new ArrayList<ToolMaterial>();
            for (Object value : ingredients) {
                int materialIndex = RANDOM.nextInt(materials.size());
                ItemStack partStack = value.getItems()[0].copy();
                partStack.set(ComponentInit.MATERIAL_COMPONENT, (Object)new MaterialComponent(materials.get(materialIndex)));
                parts.add(partStack);
                toolMaterials.add(materials.get(materialIndex));
            }
            ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)access).copy();
            resultStack.set(ComponentInit.PART_MATERIAL_COMPONENT, (Object)new PartMaterialComponent(toolMaterials));
            results.add(resultStack);
        }
        ArrayList partInputStacks = new ArrayList();
        for (Ingredient ingredient : recipe.getIngredients()) {
            ArrayList<ItemStack> variants = new ArrayList<ItemStack>();
            for (ToolMaterial material : materials) {
                ItemStack base = ingredient.getItems()[0].copy();
                base.set(ComponentInit.MATERIAL_COMPONENT, (Object)new MaterialComponent(material));
                variants.add(base);
            }
            partInputStacks.add(variants);
        }
        int partSize = recipe.getIngredients().size();
        for (int i = 0; i < partSize; ++i) {
            int y;
            int x;
            if (partSize <= 3) {
                int totalWidth = partSize * 18;
                int startX = 19 + (54 - totalWidth) / 2;
                x = startX + i * 18;
                y = 13;
            } else if (partSize == 4) {
                row = i / 2;
                col = i % 2;
                x = 19 + col * 18 + 9;
                y = 4 + row * 18;
            } else {
                row = i / 3;
                col = i % 3;
                x = 19 + col * 18;
                y = 4 + row * 18;
            }
            builder.addSlot(RecipeIngredientRole.INPUT, x + 1, y + 1).addItemStacks((List)partInputStacks.get(i));
        }
        Collections.shuffle(results);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 102, 14).addItemStacks(results);
    }
}

