/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.damage;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import net.stln.magitech.damage.ElementAffinity;
import net.stln.magitech.element.Element;
import net.stln.magitech.util.TableHelper;
import org.jetbrains.annotations.NotNull;

public class ElementAffinityRegister {
    private static final Table<Element, Boolean, List<Element>> dict = HashBasedTable.create();
    public static boolean EFFICIENT = true;
    public static boolean INEFFICIENT = false;

    @NotNull
    public static ElementAffinity getElementAffinity(@NotNull Element element, @NotNull Element targetElement) {
        if (dict.containsRow((Object)element)) {
            if (ElementAffinityRegister.getElements(element, EFFICIENT).contains((Object)targetElement)) {
                return ElementAffinity.EFFICIENT;
            }
            if (ElementAffinityRegister.getElements(element, INEFFICIENT).contains((Object)targetElement)) {
                return ElementAffinity.INEFFICIENT;
            }
        }
        return ElementAffinity.NORMAL;
    }

    public static void registerAffinity(@NotNull Element element, boolean efficiency, @NotNull Element target) {
        List<Element> list = ElementAffinityRegister.getElements(element, efficiency);
        list.add(target);
        dict.put((Object)element, (Object)efficiency, list);
    }

    @NotNull
    private static List<Element> getElements(@NotNull Element element, boolean bool) {
        return TableHelper.computeIfAbsent(dict, element, bool, (t, u) -> new ArrayList());
    }
}

