/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.datagen;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.stln.magitech.block.BlockInit;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "magitech", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.sideBottomTopBlockWithItem((Block)BlockInit.ENGINEERING_WORKBENCH.get());
        this.sideBottomTopBlockWithItem((Block)BlockInit.ASSEMBLY_WORKBENCH.get());
        this.sideBottomTopBlockWithItem((Block)BlockInit.REPAIRING_WORKBENCH.get());
        this.sideBottomTopBlockWithItem((Block)BlockInit.UPGRADE_WORKBENCH.get());
        this.horizontalHandModeledBlockWithItem((Block)BlockInit.TOOL_HANGER.get());
        this.handModeledBlockWithItem((Block)BlockInit.ALCHEMETRIC_PYLON.get());
        this.handModeledBlockWithItem((Block)BlockInit.ATHANOR_PILLAR.get());
        this.handModeledBlockWithItem((Block)BlockInit.ZARDIUS_CRUCIBLE.get());
        this.directionalHandModeledBlockWithItem((Block)BlockInit.MANA_NODE.get());
        this.handModeledBlockWithInventoryModelItem((Block)BlockInit.MANA_VESSEL.get());
        this.blockWithItem((Block)BlockInit.FLUORITE_ORE.get());
        this.blockWithItem((Block)BlockInit.DEEPSLATE_FLUORITE_ORE.get());
        this.blockWithItem((Block)BlockInit.TOURMALINE_ORE.get());
        this.blockWithItem((Block)BlockInit.DEEPSLATE_TOURMALINE_ORE.get());
        this.blockWithItem((Block)BlockInit.ZINC_ORE.get());
        this.blockWithItem((Block)BlockInit.DEEPSLATE_ZINC_ORE.get());
        this.blockWithItem((Block)BlockInit.RAW_ZINC_BLOCK.get());
        this.blockWithItem((Block)BlockInit.SULFUR_BLOCK.get());
        this.blockWithItem((Block)BlockInit.ALCHECRYSITE.get());
        this.stairsBlockWithItem((Block)BlockInit.ALCHECRYSITE_STAIRS.get(), (Block)BlockInit.ALCHECRYSITE.get());
        this.slabBlockWithItem((Block)BlockInit.ALCHECRYSITE_SLAB.get(), (Block)BlockInit.ALCHECRYSITE.get());
        this.wallBlockWithItem((Block)BlockInit.ALCHECRYSITE_WALL.get(), (Block)BlockInit.ALCHECRYSITE.get());
        this.blockWithItem((Block)BlockInit.POLISHED_ALCHECRYSITE.get());
        this.stairsBlockWithItem((Block)BlockInit.POLISHED_ALCHECRYSITE_STAIRS.get(), (Block)BlockInit.POLISHED_ALCHECRYSITE.get());
        this.slabBlockWithItem((Block)BlockInit.POLISHED_ALCHECRYSITE_SLAB.get(), (Block)BlockInit.POLISHED_ALCHECRYSITE.get());
        this.wallBlockWithItem((Block)BlockInit.POLISHED_ALCHECRYSITE_WALL.get(), (Block)BlockInit.POLISHED_ALCHECRYSITE.get());
        this.blockWithItem((Block)BlockInit.ALCHECRYSITE_BRICKS.get());
        this.stairsBlockWithItem((Block)BlockInit.ALCHECRYSITE_BRICK_STAIRS.get(), (Block)BlockInit.ALCHECRYSITE_BRICKS.get());
        this.slabBlockWithItem((Block)BlockInit.ALCHECRYSITE_BRICK_SLAB.get(), (Block)BlockInit.ALCHECRYSITE_BRICKS.get());
        this.wallBlockWithItem((Block)BlockInit.ALCHECRYSITE_BRICK_WALL.get(), (Block)BlockInit.ALCHECRYSITE_BRICKS.get());
        this.blockWithItem((Block)BlockInit.ALCHECRYSITE_TILES.get());
        this.blockWithItem((Block)BlockInit.FLUORITE_BLOCK.get());
        this.blockWithItem((Block)BlockInit.FLUORITE_BRICKS.get());
        this.stairsBlockWithItem((Block)BlockInit.FLUORITE_BRICK_STAIRS.get(), (Block)BlockInit.FLUORITE_BRICKS.get());
        this.slabBlockWithItem((Block)BlockInit.FLUORITE_BRICK_SLAB.get(), (Block)BlockInit.FLUORITE_BRICKS.get());
        this.wallBlockWithItem((Block)BlockInit.FLUORITE_BRICK_WALL.get(), (Block)BlockInit.FLUORITE_BRICKS.get());
        this.logBlockWithItem((Block)BlockInit.CELIFERN_LOG.get());
        this.woodBlockWithItem((Block)BlockInit.CELIFERN_WOOD.get());
        this.logBlockWithItem((Block)BlockInit.STRIPPED_CELIFERN_LOG.get());
        this.woodBlockWithItem((Block)BlockInit.STRIPPED_CELIFERN_WOOD.get());
        this.blockWithItem((Block)BlockInit.CELIFERN_PLANKS.get());
        this.stairsBlockWithItem((Block)BlockInit.CELIFERN_STAIRS.get(), (Block)BlockInit.CELIFERN_PLANKS.get());
        this.slabBlockWithItem((Block)BlockInit.CELIFERN_SLAB.get(), (Block)BlockInit.CELIFERN_PLANKS.get());
        this.fenceBlockWithItem((Block)BlockInit.CELIFERN_FENCE.get(), (Block)BlockInit.CELIFERN_PLANKS.get());
        this.fenceGateBlockWithItem((Block)BlockInit.CELIFERN_FENCE_GATE.get(), (Block)BlockInit.CELIFERN_PLANKS.get());
        this.doorBlock((Block)BlockInit.CELIFERN_DOOR.get());
        this.trapdoorBlockWithItem((Block)BlockInit.CELIFERN_TRAPDOOR.get(), true);
        this.pressurePlateBlockWithItem((Block)BlockInit.CELIFERN_PRESSURE_PLATE.get(), (Block)BlockInit.CELIFERN_PLANKS.get());
        this.buttonBlockWithItem((Block)BlockInit.CELIFERN_BUTTON.get(), (Block)BlockInit.CELIFERN_PLANKS.get());
        this.leavesBlockWithItem((Block)BlockInit.CELIFERN_LEAVES.get());
        this.saplingBlock((Block)BlockInit.CELIFERN_SAPLING.get());
        this.signBlock((Block)BlockInit.CELIFERN_SIGN.get(), (Block)BlockInit.CELIFERN_WALL_SIGN.get(), (Block)BlockInit.CELIFERN_PLANKS.get());
        this.hangingSignBlock((Block)BlockInit.CELIFERN_HANGING_SIGN.get(), (Block)BlockInit.CELIFERN_WALL_HANGING_SIGN.get(), (Block)BlockInit.STRIPPED_CELIFERN_LOG.get());
        this.logBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_LOG.get());
        this.woodBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_WOOD.get());
        this.logBlockWithItem((Block)BlockInit.STRIPPED_CHARCOAL_BIRCH_LOG.get());
        this.woodBlockWithItem((Block)BlockInit.STRIPPED_CHARCOAL_BIRCH_WOOD.get());
        this.blockWithItem((Block)BlockInit.CHARCOAL_BIRCH_PLANKS.get());
        this.stairsBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_STAIRS.get(), (Block)BlockInit.CHARCOAL_BIRCH_PLANKS.get());
        this.slabBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_SLAB.get(), (Block)BlockInit.CHARCOAL_BIRCH_PLANKS.get());
        this.fenceBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_FENCE.get(), (Block)BlockInit.CHARCOAL_BIRCH_PLANKS.get());
        this.fenceGateBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_FENCE_GATE.get(), (Block)BlockInit.CHARCOAL_BIRCH_PLANKS.get());
        this.doorBlock((Block)BlockInit.CHARCOAL_BIRCH_DOOR.get());
        this.trapdoorBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_TRAPDOOR.get(), true);
        this.pressurePlateBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_PRESSURE_PLATE.get(), (Block)BlockInit.CHARCOAL_BIRCH_PLANKS.get());
        this.buttonBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_BUTTON.get(), (Block)BlockInit.CHARCOAL_BIRCH_PLANKS.get());
        this.leavesBlockWithItem((Block)BlockInit.CHARCOAL_BIRCH_LEAVES.get());
        this.saplingBlock((Block)BlockInit.CHARCOAL_BIRCH_SAPLING.get());
        this.signBlock((Block)BlockInit.CHARCOAL_BIRCH_SIGN.get(), (Block)BlockInit.CHARCOAL_BIRCH_WALL_SIGN.get(), (Block)BlockInit.CHARCOAL_BIRCH_PLANKS.get());
        this.hangingSignBlock((Block)BlockInit.CHARCOAL_BIRCH_HANGING_SIGN.get(), (Block)BlockInit.CHARCOAL_BIRCH_WALL_HANGING_SIGN.get(), (Block)BlockInit.STRIPPED_CHARCOAL_BIRCH_LOG.get());
        this.grassBlockWithItem((Block)BlockInit.SCORCHED_GRASS_SOIL.get(), (Block)BlockInit.SCORCHED_SOIL.get());
        this.blockWithItem((Block)BlockInit.SCORCHED_SOIL.get());
    }

    private String getName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    private void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile(this.blockTexture(block)));
    }

    private void handModeledBlockWithItem(Block block) {
        this.simpleBlock(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile(this.blockTexture(block)));
    }

    private void handModeledBlockWithInventoryModelItem(Block block) {
        this.simpleBlock(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile(this.blockTexture(block).withSuffix("_inventory")));
    }

    private void sideBottomTopBlockWithItem(Block block) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().cubeBottomTop(this.getName(block), this.blockTexture(block).withSuffix("_side"), this.blockTexture(block).withSuffix("_bottom"), this.blockTexture(block).withSuffix("_top")));
        this.blockItem(block);
    }

    private void grassBlockWithItem(Block block, Block soil) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().cubeBottomTop(this.getName(block), this.blockTexture(block).withSuffix("_side"), this.blockTexture(soil), this.blockTexture(block).withSuffix("_top")));
        this.blockItem(block);
    }

    private void directionalHandModeledBlockWithItem(Block block) {
        this.directionalBlock(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
        this.blockItem(block);
    }

    private void horizontalHandModeledBlockWithItem(Block block) {
        this.horizontalBlock(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
        this.blockItem(block);
    }

    private void logBlockWithItem(Block block) {
        this.logBlock((RotatedPillarBlock)block);
        this.blockItem(block);
    }

    private void woodBlockWithItem(Block block) {
        ResourceLocation resourceLocation = ResourceLocation.parse((String)this.blockTexture(block).toString().replace("_wood", "_log"));
        this.axisBlock((RotatedPillarBlock)block, resourceLocation, resourceLocation);
        this.blockItem(block);
    }

    private void stairsBlockWithItem(Block block, Block fullTextureBlock) {
        this.stairsBlock((StairBlock)block, this.blockTexture(fullTextureBlock));
        this.blockItem(block);
    }

    private void slabBlockWithItem(Block block, Block fullTextureBlock) {
        this.slabBlock((SlabBlock)block, this.blockTexture(fullTextureBlock), this.blockTexture(fullTextureBlock));
        this.blockItem(block);
    }

    private void fenceBlockWithItem(Block block, Block fullTextureBlock) {
        this.fenceBlock((FenceBlock)block, this.blockTexture(fullTextureBlock));
        this.simpleBlockItem(block, (ModelFile)this.models().fenceInventory(this.getName(block) + "_inventory", this.blockTexture(fullTextureBlock)));
    }

    private void wallBlockWithItem(Block block, Block fullTextureBlock) {
        this.wallBlock((WallBlock)block, this.blockTexture(fullTextureBlock));
        this.simpleBlockItem(block, (ModelFile)this.models().wallInventory(this.getName(block) + "_inventory", this.blockTexture(fullTextureBlock)));
    }

    private void fenceGateBlockWithItem(Block block, Block fullTextureBlock) {
        this.fenceGateBlock((FenceGateBlock)block, this.blockTexture(fullTextureBlock));
        this.blockItem(block);
    }

    private void doorBlock(Block block) {
        this.doorBlockWithRenderType((DoorBlock)block, this.blockTexture(block).withSuffix("_bottom"), this.blockTexture(block).withSuffix("_top"), "cutout");
    }

    private void trapdoorBlockWithItem(Block block, boolean orientable) {
        this.trapdoorBlockWithRenderType((TrapDoorBlock)block, this.blockTexture(block), orientable, "cutout");
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile(this.blockTexture(block).withSuffix("_bottom")));
    }

    private void pressurePlateBlockWithItem(Block block, Block fullTextureBlock) {
        this.pressurePlateBlock((PressurePlateBlock)block, this.blockTexture(fullTextureBlock));
        this.blockItem(block);
    }

    private void buttonBlockWithItem(Block block, Block fullTextureBlock) {
        this.buttonBlock((ButtonBlock)block, this.blockTexture(fullTextureBlock));
        this.simpleBlockItem(block, (ModelFile)this.models().buttonInventory(this.getName(block) + "_inventory", this.blockTexture(fullTextureBlock)));
    }

    private void leavesBlockWithItem(Block block) {
        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.getName(block), ResourceLocation.parse((String)"minecraft:block/leaves"), "all", this.blockTexture(block))).renderType("cutout"));
        this.blockItem(block);
    }

    private void saplingBlock(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.getName(block), this.blockTexture(block))).renderType("cutout"));
    }

    private void signBlock(Block sign, Block wallSign, Block fullTextureBlock) {
        this.signBlock((StandingSignBlock)sign, (WallSignBlock)wallSign, this.blockTexture(fullTextureBlock));
    }

    private void hangingSignBlock(Block sign, Block wallSign, Block fullTextureBlock) {
        this.hangingSignBlock((CeilingHangingSignBlock)sign, (WallHangingSignBlock)wallSign, this.blockTexture(fullTextureBlock));
    }

    private void blockWithItem(Block block) {
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }
}

