/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.element;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageType;
import net.stln.magitech.Magitech;
import net.stln.magitech.damage.DamageTypeInit;
import net.stln.magitech.damage.ElementAffinityRegister;
import org.jetbrains.annotations.NotNull;

public enum Element implements StringRepresentable
{
    NONE("none", 0xFFFFFF, 0x404040, 10551248, 20576, DamageTypeInit.MANA_DAMAGE),
    EMBER("ember", 0xFF4040, 0x400000, 0xFF4040, 0x400000, DamageTypeInit.EMBER_DAMAGE),
    GLACE("glace", 0xA0FFFF, 10304, 0xA0FFFF, 10304, DamageTypeInit.GLACE_DAMAGE),
    SURGE("surge", 6320383, 0x100040, 6320383, 0x100040, DamageTypeInit.SURGE_DAMAGE),
    PHANTOM("phantom", 0xFFFFA0, 0x403000, 0xFFFFA0, 0x403000, DamageTypeInit.PHANTOM_DAMAGE),
    TREMOR("tremor", 32896, 4128, 32896, 4128, DamageTypeInit.TREMOR_DAMAGE),
    MAGIC("magic", 16728256, 0x400020, 16728256, 0x400020, DamageTypeInit.MAGIC_DAMAGE),
    FLOW("flow", 10551104, 0x104000, 10551104, 0x104000, DamageTypeInit.FLOW_DAMAGE),
    HOLLOW("hollow", 8396992, 0x200040, 8396992, 0x200040, DamageTypeInit.HOLLOW_DAMAGE);

    public static final Codec<Element> CODEC;
    private final String id;
    private final int color;
    private final int dark;
    private final int spellColor;
    private final int spellDark;
    private final ResourceKey<DamageType> damageType;

    private Element(String id, int color, int dark, int spellColor, int spellDark, ResourceKey<DamageType> damageType) {
        this.id = id;
        this.color = color;
        this.dark = dark;
        this.spellColor = spellColor;
        this.spellDark = spellDark;
        this.damageType = damageType;
    }

    public static void registerElements() {
        Magitech.LOGGER.info("Registering Elements formagitech");
        ElementAffinityRegister.registerAffinity(EMBER, ElementAffinityRegister.INEFFICIENT, EMBER);
        ElementAffinityRegister.registerAffinity(GLACE, ElementAffinityRegister.INEFFICIENT, GLACE);
        ElementAffinityRegister.registerAffinity(SURGE, ElementAffinityRegister.INEFFICIENT, SURGE);
        ElementAffinityRegister.registerAffinity(PHANTOM, ElementAffinityRegister.INEFFICIENT, PHANTOM);
        ElementAffinityRegister.registerAffinity(TREMOR, ElementAffinityRegister.INEFFICIENT, TREMOR);
        ElementAffinityRegister.registerAffinity(MAGIC, ElementAffinityRegister.INEFFICIENT, MAGIC);
        ElementAffinityRegister.registerAffinity(FLOW, ElementAffinityRegister.INEFFICIENT, FLOW);
        ElementAffinityRegister.registerAffinity(HOLLOW, ElementAffinityRegister.INEFFICIENT, HOLLOW);
        ElementAffinityRegister.registerAffinity(EMBER, ElementAffinityRegister.EFFICIENT, SURGE);
        ElementAffinityRegister.registerAffinity(SURGE, ElementAffinityRegister.EFFICIENT, TREMOR);
        ElementAffinityRegister.registerAffinity(TREMOR, ElementAffinityRegister.EFFICIENT, GLACE);
        ElementAffinityRegister.registerAffinity(GLACE, ElementAffinityRegister.EFFICIENT, PHANTOM);
        ElementAffinityRegister.registerAffinity(PHANTOM, ElementAffinityRegister.EFFICIENT, MAGIC);
        ElementAffinityRegister.registerAffinity(MAGIC, ElementAffinityRegister.EFFICIENT, FLOW);
        ElementAffinityRegister.registerAffinity(FLOW, ElementAffinityRegister.EFFICIENT, HOLLOW);
        ElementAffinityRegister.registerAffinity(HOLLOW, ElementAffinityRegister.EFFICIENT, EMBER);
        ElementAffinityRegister.registerAffinity(EMBER, ElementAffinityRegister.EFFICIENT, GLACE);
        ElementAffinityRegister.registerAffinity(GLACE, ElementAffinityRegister.EFFICIENT, MAGIC);
        ElementAffinityRegister.registerAffinity(MAGIC, ElementAffinityRegister.EFFICIENT, SURGE);
        ElementAffinityRegister.registerAffinity(SURGE, ElementAffinityRegister.EFFICIENT, PHANTOM);
        ElementAffinityRegister.registerAffinity(PHANTOM, ElementAffinityRegister.EFFICIENT, HOLLOW);
        ElementAffinityRegister.registerAffinity(HOLLOW, ElementAffinityRegister.EFFICIENT, TREMOR);
        ElementAffinityRegister.registerAffinity(TREMOR, ElementAffinityRegister.EFFICIENT, FLOW);
        ElementAffinityRegister.registerAffinity(FLOW, ElementAffinityRegister.EFFICIENT, EMBER);
    }

    public String get() {
        return this.id;
    }

    public MutableComponent getSpellElementName() {
        if (this == NONE) {
            return Component.translatable((String)"element.magitech.mana");
        }
        return Component.translatable((String)("element.magitech." + this.id));
    }

    public int getColor() {
        return this.color;
    }

    public int getDark() {
        return this.dark;
    }

    public int getSpellColor() {
        return this.spellColor;
    }

    public int getSpellDark() {
        return this.spellDark;
    }

    public ResourceKey<DamageType> getDamageType() {
        return this.damageType;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.fromEnum(Element::values);
    }
}

