/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.stln.magitech.Magitech;
import net.stln.magitech.entity.magicentity.aeltherin.AeltherinEntity;
import net.stln.magitech.entity.magicentity.aeltherin.AeltherinRenderer;
import net.stln.magitech.entity.magicentity.arcaleth.ArcalethEntity;
import net.stln.magitech.entity.magicentity.arcaleth.ArcalethRenderer;
import net.stln.magitech.entity.magicentity.frigala.FrigalaEntity;
import net.stln.magitech.entity.magicentity.frigala.FrigalaRenderer;
import net.stln.magitech.entity.magicentity.ignisca.IgniscaEntity;
import net.stln.magitech.entity.magicentity.ignisca.IgniscaRenderer;
import net.stln.magitech.entity.magicentity.mirazien.MirazienEntity;
import net.stln.magitech.entity.magicentity.mirazien.MirazienRenderer;
import net.stln.magitech.entity.magicentity.nullixis.NullixisEntity;
import net.stln.magitech.entity.magicentity.nullixis.NullixisRenderer;
import net.stln.magitech.entity.magicentity.tremivox.TremivoxEntity;
import net.stln.magitech.entity.magicentity.tremivox.TremivoxRenderer;
import net.stln.magitech.entity.magicentity.voltaris.VoltarisEntity;
import net.stln.magitech.entity.magicentity.voltaris.VoltarisRenderer;
import net.stln.magitech.entity.mob.WeaverEntity;
import net.stln.magitech.entity.mob.WeaverRenderer;

@EventBusSubscriber(modid="magitech")
public class EntityInit {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"magitech");
    public static final Supplier<EntityType<IgniscaEntity>> IGNISCA_ENTITY = EntityInit.registerMobEntity("ignisca", IgniscaEntity::new, MobCategory.MISC, builder -> builder.sized(0.5f, 0.5f));
    public static final Supplier<EntityType<FrigalaEntity>> FRIGALA_ENTITY = EntityInit.registerMobEntity("frigala", FrigalaEntity::new, MobCategory.MISC, builder -> builder.sized(0.5f, 0.5f));
    public static final Supplier<EntityType<VoltarisEntity>> VOLTARIS_ENTITY = EntityInit.registerMobEntity("voltaris", VoltarisEntity::new, MobCategory.MISC, builder -> builder.sized(1.0f, 1.0f));
    public static final Supplier<EntityType<MirazienEntity>> MIRAZIEN_ENTITY = EntityInit.registerMobEntity("mirazien", MirazienEntity::new, MobCategory.MISC, builder -> builder.sized(0.5f, 0.5f));
    public static final Supplier<EntityType<TremivoxEntity>> TREMIVOX_ENTITY = EntityInit.registerMobEntity("tremivox", TremivoxEntity::new, MobCategory.MISC, builder -> builder.sized(0.75f, 0.75f));
    public static final Supplier<EntityType<ArcalethEntity>> ARCALETH_ENTITY = EntityInit.registerMobEntity("arcaleth", ArcalethEntity::new, MobCategory.MISC, builder -> builder.sized(0.5f, 0.5f));
    public static final Supplier<EntityType<AeltherinEntity>> AELTHERIN_ENTITY = EntityInit.registerMobEntity("aeltherin", AeltherinEntity::new, MobCategory.MISC, builder -> builder.sized(0.5f, 0.5f));
    public static final Supplier<EntityType<NullixisEntity>> NULLIXIS_ENTITY = EntityInit.registerMobEntity("nullixis", NullixisEntity::new, MobCategory.MISC, builder -> builder.sized(0.5f, 0.5f));
    public static final Supplier<EntityType<WeaverEntity>> WEAVER_ENTITY = EntityInit.registerMobEntity("weaver", WeaverEntity::new, MobCategory.MONSTER, builder -> builder.sized(0.6f, 2.0f).eyeHeight(1.62f).clientTrackingRange(8));

    public static void registerModEntities(IEventBus eventBus) {
        Magitech.LOGGER.info("Registering Entity for magitech");
        ENTITY_TYPES.register(eventBus);
    }

    public static void registerModEntitiesRenderer() {
        Magitech.LOGGER.info("Registering Entity Renderer for magitech");
        EntityRenderers.register(IGNISCA_ENTITY.get(), IgniscaRenderer::new);
        EntityRenderers.register(FRIGALA_ENTITY.get(), FrigalaRenderer::new);
        EntityRenderers.register(VOLTARIS_ENTITY.get(), VoltarisRenderer::new);
        EntityRenderers.register(MIRAZIEN_ENTITY.get(), MirazienRenderer::new);
        EntityRenderers.register(TREMIVOX_ENTITY.get(), TremivoxRenderer::new);
        EntityRenderers.register(ARCALETH_ENTITY.get(), ArcalethRenderer::new);
        EntityRenderers.register(AELTHERIN_ENTITY.get(), AeltherinRenderer::new);
        EntityRenderers.register(NULLIXIS_ENTITY.get(), NullixisRenderer::new);
        EntityRenderers.register(WEAVER_ENTITY.get(), WeaverRenderer::new);
    }

    private static <T extends Entity> Supplier<EntityType<T>> registerMobEntity(String path, EntityType.EntityFactory<T> factory, MobCategory category, UnaryOperator<EntityType.Builder<T>> operator) {
        return ENTITY_TYPES.register(path, id -> ((EntityType.Builder)operator.apply(EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category))).build(id.getPath()));
    }

    @SubscribeEvent
    public static void registerDefaultAttributes(EntityAttributeCreationEvent event) {
        Magitech.LOGGER.info("Registering Entity Attribute for magitech");
        event.put(WEAVER_ENTITY.get(), WeaverEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(WEAVER_ENTITY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }
}

