/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import net.stln.magitech.element.Element;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public abstract class SpellProjectileEntity
extends Projectile
implements GeoEntity {
    public AbstractArrow.Pickup pickup = AbstractArrow.Pickup.DISALLOWED;
    protected boolean inGround;
    protected int inGroundTime;
    protected float damage;
    @Nullable
    private BlockState lastState;
    private int life;
    private SoundEvent soundEvent = this.getDefaultHitGroundSoundEvent();
    private ItemStack firedFromWeapon = null;

    protected SpellProjectileEntity(EntityType<? extends SpellProjectileEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected SpellProjectileEntity(EntityType<? extends SpellProjectileEntity> entityType, double x, double y, double z, Level level, @Nullable ItemStack firedFromWeapon, float damage) {
        this(entityType, level);
        this.setPos(x, y, z);
        this.damage = damage;
        if (firedFromWeapon != null && level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (firedFromWeapon.isEmpty()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.firedFromWeapon = firedFromWeapon.copy();
        }
    }

    protected SpellProjectileEntity(EntityType<? extends SpellProjectileEntity> entityType, LivingEntity owner, Level level, @Nullable ItemStack firedFromWeapon, float damage) {
        this(entityType, owner.getX(), owner.getEyeY() - (double)0.1f, owner.getZ(), level, firedFromWeapon, damage);
        this.setOwner((Entity)owner);
    }

    public void tick() {
        Vec3 vec3;
        boolean flag;
        block16: {
            BlockHitResult hitresult;
            block17: {
                super.tick();
                flag = true;
                vec3 = this.getDeltaMovement();
                if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
                    double d0 = vec3.horizontalDistance();
                    this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
                    this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 180.0 / 3.1415927410125732));
                    this.yRotO = this.getYRot();
                    this.xRotO = this.getXRot();
                }
                BlockPos blockpos = this.blockPosition();
                BlockState blockstate = this.level().getBlockState(blockpos);
                blockstate.isAir();
                if (this.isInWaterOrRain() || blockstate.is(Blocks.POWDER_SNOW) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
                    this.clearFire();
                }
                this.inGroundTime = 0;
                Vec3 vec32 = this.position();
                Vec3 vec33 = vec32.add(vec3);
                hitresult = this.level().clip(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (hitresult.getType() != HitResult.Type.MISS) {
                    vec33 = hitresult.getLocation();
                }
                if (this.isRemoved()) break block16;
                EntityHitResult entityhitresult = this.findHitEntity(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult == null || hitresult.getType() == HitResult.Type.MISS) break block17;
                if (EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) break block16;
                ProjectileDeflection projectiledeflection = this.hitTargetOrDeflectSelf((HitResult)hitresult);
                this.hasImpulse = true;
                if (projectiledeflection != ProjectileDeflection.NONE) break block16;
            }
            if (hitresult != null) {
                hitresult.getType();
            }
        }
        vec3 = this.getDeltaMovement();
        double d5 = vec3.x;
        double d6 = vec3.y;
        double d1 = vec3.z;
        double d7 = this.getX() + d5;
        double d2 = this.getY() + d6;
        double d3 = this.getZ() + d1;
        double d4 = vec3.horizontalDistance();
        if (flag) {
            this.setYRot((float)(Mth.atan2((double)(-d5), (double)(-d1)) * 180.0 / 3.1415927410125732));
        } else {
            this.setYRot((float)(Mth.atan2((double)d5, (double)d1) * 180.0 / 3.1415927410125732));
        }
        this.setXRot((float)(Mth.atan2((double)d6, (double)d4) * 180.0 / 3.1415927410125732));
        this.setXRot(SpellProjectileEntity.lerpRotation((float)this.xRotO, (float)this.getXRot()));
        this.setYRot(SpellProjectileEntity.lerpRotation((float)this.yRotO, (float)this.getYRot()));
        if (this.isInWater()) {
            for (int j = 0; j < 4; ++j) {
                float f1 = 0.25f;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
            }
        }
        if (!flag) {
            this.applyGravity();
        }
        this.setPos(d7, d2, d3);
        this.checkInsideBlocks();
        if (this.tickCount >= 1200) {
            this.discard();
        }
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        float f = (float)this.getDeltaMovement().length();
        Entity entity1 = this.getOwner();
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    @NotNull
    protected DamageSource getElementalDamageSource(Entity owner, ResourceKey<DamageType> damageType) {
        DamageSource elementalDamageSource = owner != null ? owner.damageSources().source(damageType, owner) : this.damageSources().source(damageType);
        return elementalDamageSource;
    }

    protected void applyDamage(Entity entity, DamageSource damageSource, float amount) {
        LivingEntity livingEntity;
        int i = entity.getRemainingFireTicks();
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)owner;
            livingentity1.setLastHurtMob(entity);
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                livingEntity.setLastHurtByMob(livingentity1);
            }
        }
        if (entity.hurt(damageSource, amount)) {
            if (this.firedFromWeapon != null && (livingEntity = this.firedFromWeapon.getItem()) instanceof PartToolItem) {
                PartToolItem toolItem = (PartToolItem)livingEntity;
                toolItem.callTraitSpellHitEntity(this.level(), (Player)owner, entity, this.firedFromWeapon);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                }
                if (!this.level().isClientSide && owner instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)owner;
                }
            }
            this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        } else {
            entity.setRemainingFireTicks(i);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                this.discard();
            }
        }
    }

    protected Element getElement() {
        return Element.NONE;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.ARROW_HIT;
    }

    protected final SoundEvent getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(LivingEntity target) {
    }

    public void setDamage(float value) {
        this.damage = value;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putShort("life", (short)this.life);
        if (this.lastState != null) {
            compound.put("inBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.lastState));
        }
        compound.putBoolean("inGround", this.inGround);
        compound.putFloat("damage", this.damage);
        compound.putString("SoundEvent", BuiltInRegistries.SOUND_EVENT.getKey((Object)this.soundEvent).toString());
        if (this.firedFromWeapon != null) {
            compound.put("weapon", this.firedFromWeapon.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.life = compound.getShort("life");
        if (compound.contains("inBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("inBlockState"));
        }
        this.inGround = compound.getBoolean("inGround");
        if (compound.contains("damage", 99)) {
            this.damage = compound.getFloat("damage");
        }
        if (compound.contains("SoundEvent", 8)) {
            this.soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(ResourceLocation.parse((String)compound.getString("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        this.firedFromWeapon = compound.contains("weapon", 10) ? (ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("weapon")).orElse(null) : null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

