/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.magicentity.aeltherin;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.EntityInit;
import net.stln.magitech.entity.SpellProjectileEntity;
import net.stln.magitech.particle.particle_option.BlowParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.DataMapHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AeltherinEntity
extends SpellProjectileEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AeltherinEntity(EntityType<? extends SpellProjectileEntity> entityType, Level world) {
        super(entityType, world);
    }

    public AeltherinEntity(Level world, Player player, float damage) {
        super(EntityInit.AELTHERIN_ENTITY.get(), (LivingEntity)player, world, null, damage);
    }

    public AeltherinEntity(Level world, Player player, ItemStack weapon, float damage) {
        super(EntityInit.AELTHERIN_ENTITY.get(), (LivingEntity)player, world, weapon, damage);
    }

    public AeltherinEntity(EntityType<? extends SpellProjectileEntity> type, double x, double y, double z, Level world, ItemStack stack, @Nullable ItemStack weapon, float damage) {
        super(type, x, y, z, world, weapon, damage);
    }

    public AeltherinEntity(EntityType<? extends SpellProjectileEntity> type, LivingEntity owner, Level world, ItemStack stack, @Nullable ItemStack shotFrom, float damage) {
        super(type, owner, world, shotFrom, damage);
    }

    @Override
    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f toColor = new Vector3f(1.0f, 1.0f, 1.0f);
            float scale = 1.0f;
            int twinkle = 1;
            float rotSpeed = 0.0f;
            int particleAmount = 5;
            for (int i = 0; i < particleAmount; ++i) {
                Vec3 deltaMovement = this.getDeltaMovement();
                double x = this.getX() - deltaMovement.x + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double y = this.getY(0.5) - deltaMovement.y + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double z = this.getZ() - deltaMovement.z + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double vx = deltaMovement.x / 4.0;
                double vy = deltaMovement.y / 4.0;
                double vz = deltaMovement.z / 4.0;
                world.addParticle((ParticleOptions)new BlowParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
            }
        } else {
            this.addDeltaMovement(this.getDeltaMovement().scale(0.3));
        }
        if (this.getDeltaMovement().length() > 100.0) {
            this.discard();
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        Entity owner = this.getOwner();
        ResourceKey<DamageType> damageType = this.getElement().getDamageType();
        DamageSource elementalDamageSource = this.getElementalDamageSource(owner, damageType);
        float finalDamage = this.damage * DataMapHelper.getElementMultiplier(entity, this.getElement());
        this.applyDamage(entity, elementalDamageSource, finalDamage);
        this.hitParticle();
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
    }

    @Override
    protected void applyDamage(Entity entity, DamageSource damageSource, float amount) {
        super.applyDamage(entity, damageSource, amount);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.knockback(2.0, -this.getDeltaMovement().x, -this.getDeltaMovement().z);
        }
    }

    @Override
    protected Element getElement() {
        return Element.FLOW;
    }

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.hitParticle();
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            if (this.level().isClientSide) {
                this.hitParticle();
            } else {
                this.discard();
            }
        }
        super.handleEntityEvent(status);
    }

    protected void hitParticle() {
        Level world = this.level();
        if (world.isClientSide) {
            Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f toColor = new Vector3f(1.0f, 1.0f, 1.0f);
            float scale = 1.0f;
            float rotSpeed = 0.0f;
            int particleAmount = 10;
            for (int i = 0; i < particleAmount; ++i) {
                int twinkle = 1;
                double x = this.getX() - this.getDeltaMovement().x + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double y = this.getY(0.5) - this.getDeltaMovement().y + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double z = this.getZ() - this.getDeltaMovement().z + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double vx = ((double)this.random.nextFloat() - 0.5) / 6.0;
                double vy = ((double)this.random.nextFloat() - 0.5) / 6.0;
                double vz = ((double)this.random.nextFloat() - 0.5) / 6.0;
                Vector3f endPos = this.position().add(new Vec3((double)(this.random.nextFloat() * 4.0f - 2.0f), (double)(this.random.nextFloat() * 4.0f - 2.0f), (double)(this.random.nextFloat() * 4.0f - 2.0f))).toVector3f();
                world.addParticle((ParticleOptions)new BlowParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
            }
        }
    }

    @Override
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundInit.AELTHERIN.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idle", event -> event.setAndContinue(IDLE)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

