/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.magicentity.frigala;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.entity.magicentity.frigala.FrigalaEntity;
import net.stln.magitech.entity.magicentity.frigala.FrigalaModel;
import net.stln.magitech.util.RenderHelper;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.Color;

public class FrigalaRenderer
extends GeoEntityRenderer<FrigalaEntity> {
    public FrigalaRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new FrigalaModel());
    }

    public Color getRenderColor(FrigalaEntity animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    @Nullable
    public RenderType getRenderType(FrigalaEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderHelper.additiveNoCull(texture);
    }

    protected void applyRotations(FrigalaEntity animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        Vec3 velocity = animatable.getDeltaMovement();
        if (!velocity.equals((Object)Vec3.ZERO)) {
            double horizontalSpeed = Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z);
            float yaw2 = (float)(-Math.toDegrees(Math.atan2(-velocity.x, velocity.z)));
            float pitch = (float)(-Math.toDegrees(Math.atan2(-velocity.y, horizontalSpeed)));
            poseStack.rotateAround(Axis.YP.rotationDegrees(yaw2), 0.0f, animatable.getBbHeight() / 2.0f, 0.0f);
            poseStack.rotateAround(Axis.XN.rotationDegrees(pitch), 0.0f, animatable.getBbHeight() / 2.0f, 0.0f);
            poseStack.translate(0.0, (double)(animatable.getBbHeight() / 2.0f), 0.0);
        }
        super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
    }
}

