/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.magicentity.tremivox;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.EntityInit;
import net.stln.magitech.entity.SpellProjectileEntity;
import net.stln.magitech.particle.particle_option.WaveParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.DataMapHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TremivoxEntity
extends SpellProjectileEntity
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public TremivoxEntity(EntityType<? extends SpellProjectileEntity> entityType, Level world) {
        super(entityType, world);
    }

    public TremivoxEntity(Level world, Player player, float damage) {
        super(EntityInit.TREMIVOX_ENTITY.get(), (LivingEntity)player, world, null, damage);
    }

    public TremivoxEntity(Level world, Player player, ItemStack weapon, float damage) {
        super(EntityInit.TREMIVOX_ENTITY.get(), (LivingEntity)player, world, weapon, damage);
    }

    public TremivoxEntity(EntityType<? extends SpellProjectileEntity> type, double x, double y, double z, Level world, ItemStack stack, @Nullable ItemStack weapon, float damage) {
        super(type, x, y, z, world, weapon, damage);
    }

    public TremivoxEntity(EntityType<? extends SpellProjectileEntity> type, LivingEntity owner, Level world, ItemStack stack, @Nullable ItemStack shotFrom, float damage) {
        super(type, owner, world, shotFrom, damage);
    }

    @Override
    public void tick() {
        super.tick();
        Level world = this.level();
        Vec3 deltaMovement = this.getDeltaMovement();
        if (world.isClientSide) {
            Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f toColor = new Vector3f(1.0f, 1.0f, 1.0f);
            float scale = 1.0f;
            int twinkle = 1;
            float rotSpeed = 0.0f;
            int particleAmount = 5;
            for (int i = 0; i < particleAmount; ++i) {
                double x = this.getX() - deltaMovement.x + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double y = this.getY(0.5) - deltaMovement.y + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double z = this.getZ() - deltaMovement.z + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double vx = deltaMovement.x / 4.0;
                double vy = deltaMovement.y / 4.0;
                double vz = deltaMovement.z / 4.0;
                world.addParticle((ParticleOptions)new WaveParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
            }
        } else {
            LivingEntity target;
            Vec3 center = this.position().add(this.getDeltaMovement().normalize().scale(10.0));
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                target = world.getNearestEntity(LivingEntity.class, TargetingConditions.forCombat(), livingEntity, this.getX(), this.getY(), this.getZ(), new AABB(center.subtract(10.0, 10.0, 10.0), center.add(10.0, 10.0, 10.0)));
            } else {
                target = world.getNearestEntity(LivingEntity.class, TargetingConditions.forCombat(), null, this.getX(), this.getY(), this.getZ(), new AABB(center.subtract(10.0, 10.0, 10.0), center.add(10.0, 10.0, 10.0)));
            }
            if (target != null) {
                this.setDeltaMovement(target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0).subtract(this.position()).normalize().scale(0.15).add(deltaMovement).normalize().scale(deltaMovement.length()));
            }
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        Entity owner = this.getOwner();
        ResourceKey<DamageType> damageType = this.getElement().getDamageType();
        DamageSource elementalDamageSource = this.getElementalDamageSource(owner, damageType);
        float finalDamage = this.damage * DataMapHelper.getElementMultiplier(entity, this.getElement());
        this.applyDamage(entity, elementalDamageSource, finalDamage);
        this.hitParticle();
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
    }

    @Override
    protected Element getElement() {
        return Element.TREMOR;
    }

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.hitParticle();
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            if (this.level().isClientSide) {
                this.hitParticle();
            } else {
                this.discard();
            }
        }
        super.handleEntityEvent(status);
    }

    protected void hitParticle() {
        Level world = this.level();
        if (world.isClientSide) {
            Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f toColor = new Vector3f(1.0f, 1.0f, 1.0f);
            float scale = 1.0f;
            float rotSpeed = 0.0f;
            int particleAmount = 10;
            for (int i = 0; i < particleAmount; ++i) {
                int twinkle = 1;
                double x = this.getX() - this.getDeltaMovement().x + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double y = this.getY(0.5) - this.getDeltaMovement().y + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double z = this.getZ() - this.getDeltaMovement().z + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double vx = ((double)this.random.nextFloat() - 0.5) / 6.0;
                double vy = ((double)this.random.nextFloat() - 0.5) / 6.0;
                double vz = ((double)this.random.nextFloat() - 0.5) / 6.0;
                world.addParticle((ParticleOptions)new WaveParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
            }
        }
    }

    @Override
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundInit.TREMIVOX.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idle", event -> event.setAndContinue(IDLE)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

