/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.mob;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.stln.magitech.damage.DamageTypeInit;
import net.stln.magitech.entity.RangedSpellAttackGoal;
import net.stln.magitech.entity.magicentity.ignisca.IgniscaEntity;
import net.stln.magitech.network.RangedEntityAttackPayload;
import net.stln.magitech.particle.particle_option.BeamParticleEffect;
import net.stln.magitech.particle.particle_option.FrostParticleEffect;
import net.stln.magitech.particle.particle_option.SquareFieldParticleEffect;
import net.stln.magitech.particle.particle_option.SquareParticleEffect;
import net.stln.magitech.particle.particle_option.UnstableSquareParticleEffect;
import net.stln.magitech.particle.particle_option.ZapParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.TickScheduler;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WeaverEntity
extends Monster
implements GeoEntity,
RangedAttackMob {
    private static final int HARD_ATTACK_INTERVAL = 20;
    private static final int NORMAL_ATTACK_INTERVAL = 40;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation DAMAGE = RawAnimation.begin().thenPlay("damage");
    private static final RawAnimation SPELL = RawAnimation.begin().thenPlay("spell");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WeaverEntity(EntityType<? extends WeaverEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, new RangedSpellAttackGoal<WeaverEntity>(this, 1.0, 15.0f, 40, 20));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public void rideTick() {
        super.rideTick();
        Entity entity = this.getControlledVehicle();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)entity;
            this.yBodyRot = pathfindermob.yBodyRot;
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        RandomSource randomsource = level.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, difficulty);
        this.populateDefaultEquipmentEnchantments(level, randomsource, difficulty);
        this.setCanPickUpLoot(randomsource.nextFloat() < 0.55f * difficulty.getSpecialMultiplier());
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && randomsource.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)(randomsource.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN)));
                this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
            }
        }
        return spawnGroupData;
    }

    protected int getHardAttackInterval() {
        return 20;
    }

    protected int getAttackInterval() {
        return 40;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        int index = this.random.nextInt(3);
        this.performSpell(this.level(), target, index);
        if (!this.level().isClientSide) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new RangedEntityAttackPayload(this.getId(), target.getId(), distanceFactor, index), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void performSpell(Level level, LivingEntity target, int index) {
        switch (index) {
            case 0: {
                this.addLightning(level, target);
                break;
            }
            case 1: {
                this.addFrostBeam(level, target);
                break;
            }
            case 2: {
                this.addFireBall(level, target);
            }
        }
        this.triggerAnim("controller", "spell");
    }

    private void addLightning(Level level, LivingEntity target) {
        Vec3[] surface = new Vec3[]{null};
        Vec3 position = target.position();
        Vec3 oldSurface = EntityUtil.findSurface(this.level(), position);
        this.level().addParticle((ParticleOptions)new SquareFieldParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.5f, 0.5f, 1.0f), 1.0f, this.getRandom().nextInt(3, 6), 0.0f), position.x, position.y + 0.1, position.z, 0.0, 0.0, 0.0);
        for (int i = 0; i < 40; ++i) {
            Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f toColor = new Vector3f(0.5f, 0.5f, 1.0f);
            float scale = 1.0f;
            float rotSpeed = 0.0f;
            double x = oldSurface.x + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.4f, (float)0.4f);
            double y = oldSurface.y + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.4f, (float)1.4f);
            double z = oldSurface.z + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.4f, (float)0.4f);
            double vy = this.getRandom().nextFloat() / 5.0f;
            int twinkle = this.getRandom().nextInt(2, 4);
            this.level().addParticle((ParticleOptions)new UnstableSquareParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, 0.0, vy, 0.0);
        }
        TickScheduler.schedule(2, () -> {
            surface[0] = EntityUtil.findSurface(level, target.position());
        }, level.isClientSide);
        for (int j = 0; j < 3; ++j) {
            TickScheduler.schedule(5 + 10 * j, () -> {
                if (this.isAlive() && target.isAlive() && surface[0] != null && this.level() != null) {
                    this.level().addParticle((ParticleOptions)new SquareFieldParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.5f, 0.5f, 1.0f), 1.0f, this.getRandom().nextInt(3, 6), 0.0f), surface[0].x, surface[0].y + 0.1, surface[0].z, 0.0, 0.0, 0.0);
                }
                Vec3 lightningTop = surface[0].add(0.0, (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)5.0f, (float)20.0f), 0.0);
                List<Entity> entities = EntityUtil.getEntitiesInBox(level, (Entity)this, surface[0], new Vec3(2.0, 2.0, 2.0));
                level.playSound((Entity)this, BlockPos.containing((Position)surface[0]), SoundInit.ARCLUME.get(), SoundSource.HOSTILE, 1.0f, 0.8f + this.getRandom().nextFloat() * 0.6f);
                if (!level.isClientSide) {
                    DamageSource elementalDamageSource = this.damageSources().source(DamageTypeInit.SURGE_DAMAGE, (Entity)this);
                    for (Entity entity : entities) {
                        if (!entity.isInvulnerableTo(elementalDamageSource)) {
                            this.setLastHurtMob(entity);
                            if (entity instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)entity;
                                livingEntity.setLastHurtByMob((LivingEntity)this);
                            }
                        }
                        entity.hurt(elementalDamageSource, 3.0f);
                    }
                }
                if (level.isClientSide) {
                    double vz;
                    double vy;
                    double vx;
                    double z;
                    double y;
                    double x;
                    int twinkle;
                    int i;
                    level.addParticle((ParticleOptions)new ZapParticleEffect(new Vector3f(1.0f), new Vector3f(1.0f), lightningTop.toVector3f(), 2.0f, 3, 0.0f), surface[0].x, surface[0].y, surface[0].z, 0.0, 0.0, 0.0);
                    Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
                    Vector3f toColor = new Vector3f(0.5f, 0.5f, 1.0f);
                    float scale = 1.0f;
                    float rotSpeed = 0.0f;
                    int particleAmount = 20;
                    for (i = 0; i < particleAmount; ++i) {
                        twinkle = this.getRandom().nextInt(2, 4);
                        x = lightningTop.x;
                        y = lightningTop.y;
                        z = lightningTop.z;
                        vx = ((double)this.getRandom().nextFloat() - 0.5) / 10.0;
                        vy = ((double)this.getRandom().nextFloat() - 0.5) / 10.0;
                        vz = ((double)this.getRandom().nextFloat() - 0.5) / 10.0;
                        level.addParticle((ParticleOptions)new SquareParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
                    }
                    for (i = 0; i < particleAmount; ++i) {
                        twinkle = this.getRandom().nextInt(2, 4);
                        x = surface[0].x + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.2f, (float)0.2f);
                        y = surface[0].y + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.2f, (float)0.2f);
                        z = surface[0].z + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.2f, (float)0.2f);
                        vx = ((double)this.getRandom().nextFloat() - 0.5) / 2.0;
                        vy = (double)this.getRandom().nextFloat() - 0.5;
                        vz = ((double)this.getRandom().nextFloat() - 0.5) / 2.0;
                        level.addParticle((ParticleOptions)new UnstableSquareParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
                    }
                }
            }, level.isClientSide);
        }
    }

    private void addFrostBeam(Level level, LivingEntity target) {
        Vec3 forward = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(this.getEyePosition()).normalize();
        TickScheduler.schedule(3, () -> {
            Vec3 hitPos = EntityUtil.raycastBeam((Entity)this, 32.0, 0.3, forward);
            Entity beamTarget = EntityUtil.raycastBeamEntity((Entity)this, 32.0, 0.3, forward);
            Vec3 start = this.position().add(0.0, (double)this.getBbHeight() * 0.7, 0.0).add(forward.scale(0.5));
            EffectUtil.lineEffect(level, new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), start, hitPos, 2, false);
            level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.6f, 1.0f, 1.0f), hitPos.toVector3f(), 0.7f, 1, 1.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
            for (int i = 0; i < 20; ++i) {
                level.addParticle((ParticleOptions)new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), hitPos.x, hitPos.y, hitPos.z, ((double)this.getRandom().nextFloat() - 0.5) / 3.0, ((double)this.getRandom().nextFloat() - 0.5) / 3.0, ((double)this.getRandom().nextFloat() - 0.5) / 3.0);
            }
            level.playSound((Entity)this, this.blockPosition(), SoundInit.FROST_BREAK.get(), SoundSource.HOSTILE, 1.0f, 0.6f + this.getRandom().nextFloat() * 0.6f);
            if (!level.isClientSide) {
                DamageSource elementalDamageSource = this.damageSources().source(DamageTypeInit.GLACE_DAMAGE, (Entity)this);
                if (beamTarget != null) {
                    beamTarget.hurt(elementalDamageSource, 4.0f);
                    if (beamTarget instanceof LivingEntity) {
                        LivingEntity livingTarget = (LivingEntity)beamTarget;
                        beamTarget.setTicksFrozen(Math.min(beamTarget.getTicksFrozen() + 200, 320));
                    }
                }
            }
        }, level.isClientSide);
    }

    private void addFireBall(Level level, LivingEntity target) {
        Vec3 forward = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(this.getEyePosition()).normalize();
        IgniscaEntity igniscaEntity = new IgniscaEntity(level, (LivingEntity)this, 4.0f);
        igniscaEntity.setPos(this.position().add(0.0, (double)this.getBbHeight() * 0.7, 0.0));
        igniscaEntity.setDeltaMovement(forward.scale(1.0));
        level.addFreshEntity((Entity)igniscaEntity);
        level.playSound((Entity)this, this.blockPosition(), SoundInit.FIREBALL.get(), SoundSource.HOSTILE, 1.0f, 0.6f + this.getRandom().nextFloat() * 0.6f);
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeapon) {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        if (result && amount > 0.0f) {
            this.triggerAnim("controller", "damage");
        }
        return result;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundInit.WEAVER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundInit.WEAVER_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (state.isMoving()) {
                state.setAndContinue(WALK);
            } else {
                state.setAndContinue(IDLE);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("damage", DAMAGE).triggerableAnim("spell", SPELL));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected SoundEvent getStepSound() {
        return SoundInit.ALCHECRYSITE_STEP.get();
    }

    public boolean isShaking() {
        return this.isFullyFrozen();
    }
}

