/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.mob;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.stln.magitech.entity.mob.WeaverEntity;
import net.stln.magitech.entity.mob.WeaverModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class WeaverRenderer
extends GeoEntityRenderer<WeaverEntity> {
    public WeaverRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new WeaverModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
    }

    protected void applyRotations(WeaverEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float scale) {
        super.applyRotations((Entity)entity, poseStack, ageInTicks, rotationYaw, partialTick, scale);
        float netHeadYaw = entity.getViewYRot(partialTick);
        float bodyYaw = Mth.rotLerp((float)partialTick, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float headYaw = netHeadYaw - bodyYaw;
        float headPitch = entity.getViewXRot(partialTick);
        GeoBone head = this.getGeoModel().getBone("head").orElse(null);
        if (head != null) {
            head.setRotY(-headYaw * ((float)Math.PI / 180));
            head.setRotX(-headPitch * ((float)Math.PI / 180));
        }
    }
}

