/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.mob_effect;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.mob_effect.CustomMobEffect;
import net.stln.magitech.entity.mob_effect.EcholocationMobEffect;
import net.stln.magitech.entity.mob_effect.PhaseLockMobEffect;
import net.stln.magitech.entity.mob_effect.VoidrotMobEffect;
import net.stln.magitech.entity.status.AttributeInit;

public class MobEffectInit {
    private static final DeferredRegister<MobEffect> STATUS_EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"magitech");
    public static final DeferredHolder<MobEffect, MobEffect> MANA_ADDICTION = STATUS_EFFECTS.register("mana_addiction", id -> new CustomMobEffect(MobEffectCategory.NEUTRAL, 0x40FFF0).addAttributeModifier((Holder)AttributeInit.MANA_REGEN, (ResourceLocation)id, 2.0, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(AttributeInit.MAX_MANA, id, -50.0, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> MANA_REGENERATION = STATUS_EFFECTS.register("mana_regeneration", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, 8454080).addAttributeModifier((Holder)AttributeInit.MANA_REGEN, (ResourceLocation)id, 2.0, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> EMBER_POWER = STATUS_EFFECTS.register("ember_power", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, Element.EMBER.getColor()).addAttributeModifier((Holder)AttributeInit.EMBER_SPELL_POWER, (ResourceLocation)id, 0.1, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> GLACE_POWER = STATUS_EFFECTS.register("glace_power", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, Element.GLACE.getColor()).addAttributeModifier((Holder)AttributeInit.GLACE_SPELL_POWER, (ResourceLocation)id, 0.1, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> SURGE_POWER = STATUS_EFFECTS.register("surge_power", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, Element.SURGE.getColor()).addAttributeModifier((Holder)AttributeInit.SURGE_SPELL_POWER, (ResourceLocation)id, 0.1, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> PHANTOM_POWER = STATUS_EFFECTS.register("phantom_power", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, Element.PHANTOM.getColor()).addAttributeModifier((Holder)AttributeInit.PHANTOM_SPELL_POWER, (ResourceLocation)id, 0.1, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> TREMOR_POWER = STATUS_EFFECTS.register("tremor_power", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, Element.TREMOR.getColor()).addAttributeModifier((Holder)AttributeInit.TREMOR_SPELL_POWER, (ResourceLocation)id, 0.1, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> MAGIC_POWER = STATUS_EFFECTS.register("magic_power", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, Element.MAGIC.getColor()).addAttributeModifier((Holder)AttributeInit.MAGIC_SPELL_POWER, (ResourceLocation)id, 0.1, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> FLOW_POWER = STATUS_EFFECTS.register("flow_power", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, Element.FLOW.getColor()).addAttributeModifier((Holder)AttributeInit.FLOW_SPELL_POWER, (ResourceLocation)id, 0.1, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> HOLLOW_POWER = STATUS_EFFECTS.register("hollow_power", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, Element.HOLLOW.getColor()).addAttributeModifier((Holder)AttributeInit.HOLLOW_SPELL_POWER, (ResourceLocation)id, 0.1, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredHolder<MobEffect, MobEffect> LEAP_STEP = STATUS_EFFECTS.register("leap_step", id -> new CustomMobEffect(MobEffectCategory.BENEFICIAL, 0xF0F0FF).addAttributeModifier(Attributes.MOVEMENT_SPEED, (ResourceLocation)id, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(Attributes.STEP_HEIGHT, id, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    public static final DeferredHolder<MobEffect, MobEffect> SEIZE = STATUS_EFFECTS.register("seize", id -> new CustomMobEffect(MobEffectCategory.HARMFUL, 0xFFFFC0).addAttributeModifier(Attributes.MOVEMENT_SPEED, (ResourceLocation)id, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredHolder<MobEffect, MobEffect> ECHOLOCATION = STATUS_EFFECTS.register("echolocation", id -> new EcholocationMobEffect(MobEffectCategory.BENEFICIAL, 16448));
    public static final DeferredHolder<MobEffect, MobEffect> VOIDROT = STATUS_EFFECTS.register("voidrot", id -> new VoidrotMobEffect(MobEffectCategory.HARMFUL, 0x400080));
    public static final DeferredHolder<MobEffect, MobEffect> PHASELOCK = STATUS_EFFECTS.register("phase_lock", id -> new PhaseLockMobEffect(MobEffectCategory.HARMFUL, 0x200040));
    public static final DeferredHolder<MobEffect, MobEffect> CHARGE = STATUS_EFFECTS.register("charge", id -> new CustomMobEffect(MobEffectCategory.NEUTRAL, Element.SURGE.getColor()));
    public static final DeferredHolder<MobEffect, MobEffect> COOLDOWN = STATUS_EFFECTS.register("cooldown", id -> new CustomMobEffect(MobEffectCategory.NEUTRAL, 0x808080));

    public static void registerMobEffects(IEventBus eventBus) {
        Magitech.LOGGER.info("Registering Mob Effect for magitech");
        STATUS_EFFECTS.register(eventBus);
    }
}

