/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.event;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.stln.magitech.Magitech;
import net.stln.magitech.item.tool.toolitem.SpellCasterItem;

@EventBusSubscriber(modid="magitech")
public class ItemSwitchDetector {
    private static final Map<UUID, Integer> lastSlotMap = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        UUID id = player.getUUID();
        int currentSlot = player.getInventory().selected;
        int lastSlot = lastSlotMap.getOrDefault(id, -1);
        if (lastSlot != currentSlot) {
            ItemStack newItem = player.getMainHandItem();
            if (lastSlot >= 0 && player.getInventory().getItem(lastSlot).getItem() instanceof SpellCasterItem && player.level().isClientSide) {
                ItemSwitchDetector.stopAnim(player);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void stopAnim(Player player) {
        IAnimation iAnimation;
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(Magitech.id("animation"));
        if (playerAnimationData != null && (iAnimation = playerAnimationData.getAnimation()) instanceof KeyframeAnimationPlayer) {
            KeyframeAnimationPlayer keyframeAnimationPlayer = (KeyframeAnimationPlayer)iAnimation;
            keyframeAnimationPlayer.stop();
        }
    }
}

