/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui;

import java.util.function.Supplier;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.stln.magitech.Magitech;
import net.stln.magitech.gui.PartCuttingMenu;
import net.stln.magitech.gui.PartCuttingScreen;
import net.stln.magitech.gui.ThreadboundMenuType;
import net.stln.magitech.gui.ThreadboundScreen;
import net.stln.magitech.gui.ToolAssemblyMenu;
import net.stln.magitech.gui.ToolAssemblyScreen;
import net.stln.magitech.gui.ToolRepairingMenu;
import net.stln.magitech.gui.ToolRepairingScreen;
import net.stln.magitech.gui.ToolUpgradeMenu;
import net.stln.magitech.gui.ToolUpgradeScreen;
import net.stln.magitech.gui.overlay.ManaContainerInfoOverlay;
import net.stln.magitech.gui.overlay.ManaGaugeOverlay;
import net.stln.magitech.gui.overlay.SpellGaugeOverlay;

@EventBusSubscriber(modid="magitech", value={Dist.CLIENT})
public class GuiInit {
    public static final DeferredRegister<MenuType<?>> REGISTER = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"magitech");
    public static final Supplier<MenuType<PartCuttingMenu>> PART_CUTTING_MENU = GuiInit.register("part_cutting_menu", PartCuttingMenu::new);
    public static final Supplier<MenuType<ToolAssemblyMenu>> TOOL_ASSEMBLY_MENU = GuiInit.register("tool_assembly_menu", ToolAssemblyMenu::new);
    public static final Supplier<MenuType<ToolRepairingMenu>> TOOL_REPAIRING_MENU = GuiInit.register("tool_repairing_menu", ToolRepairingMenu::new);
    public static final Supplier<MenuType<ToolUpgradeMenu>> TOOL_UPGRADE_MENU = GuiInit.register("tool_upgrade_menu", ToolUpgradeMenu::new);
    public static final Supplier<MenuType<ThreadboundMenuType>> THREADBOUND_MENU = GuiInit.register("threadbound_menu", ThreadboundMenuType::new);

    private static <T extends AbstractContainerMenu> Supplier<MenuType<T>> register(String name, MenuType.MenuSupplier<T> supplier) {
        return REGISTER.register(name, () -> new MenuType(supplier, FeatureFlags.VANILLA_SET));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRegisterOverlays(RegisterGuiLayersEvent event) {
        event.registerAboveAll(Magitech.id("mana_gauge"), (LayeredDraw.Layer)new ManaGaugeOverlay());
        event.registerAboveAll(Magitech.id("spell_gauge"), (LayeredDraw.Layer)new SpellGaugeOverlay());
        event.registerAboveAll(Magitech.id("mana_container_info"), (LayeredDraw.Layer)new ManaContainerInfoOverlay());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(PART_CUTTING_MENU.get(), PartCuttingScreen::new);
        event.register(TOOL_ASSEMBLY_MENU.get(), ToolAssemblyScreen::new);
        event.register(TOOL_REPAIRING_MENU.get(), ToolRepairingScreen::new);
        event.register(TOOL_UPGRADE_MENU.get(), ToolUpgradeScreen::new);
        event.register(THREADBOUND_MENU.get(), ThreadboundScreen::new);
    }

    public static void registerMenus(IEventBus eventBus) {
        REGISTER.register(eventBus);
    }
}

