/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.gui.GuiInit;
import net.stln.magitech.recipe.PartCuttingRecipe;
import net.stln.magitech.recipe.RecipeInit;
import org.jetbrains.annotations.NotNull;

public class PartCuttingMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    final Slot inputSlot;
    final Slot resultSlot;
    final ResultContainer resultContainer = new ResultContainer();
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private final Level level;
    long lastSoundTime;
    Runnable slotUpdateListener = Runnables.doNothing();
    private List<RecipeHolder<PartCuttingRecipe>> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.EMPTY;
    public final Container container = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            PartCuttingMenu.this.slotsChanged((Container)this);
            PartCuttingMenu.this.slotUpdateListener.run();
        }
    };

    public PartCuttingMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public PartCuttingMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super(GuiInit.PART_CUTTING_MENU.get(), containerId);
        this.access = access;
        this.level = playerInventory.player.level();
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 20, 49));
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, 143, 49){

            public boolean mayPlace(ItemStack p_40362_) {
                return false;
            }

            public void onTake(Player p_150672_, ItemStack p_150673_) {
                p_150673_.onCraftedBy(p_150672_.level(), p_150672_, p_150673_.getCount());
                PartCuttingMenu.this.resultContainer.awardUsedRecipes(p_150672_, this.getRelevantItems());
                ItemStack itemstack = PartCuttingMenu.this.removeCount();
                if (!itemstack.isEmpty()) {
                    PartCuttingMenu.this.setupResultSlot();
                }
                access.execute((p_40364_, p_40365_) -> {
                    long l = p_40364_.getGameTime();
                    if (PartCuttingMenu.this.lastSoundTime != l) {
                        p_40364_.playSound(null, p_40365_, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        PartCuttingMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(p_150672_, p_150673_);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(PartCuttingMenu.this.inputSlot.getItem());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 175));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    private static SingleRecipeInput createRecipeInput(Container container) {
        return new SingleRecipeInput(container.getItem(0));
    }

    @NotNull
    private ItemStack removeCount() {
        return this.inputSlot.remove(((PartCuttingRecipe)this.recipes.get(this.selectedRecipeIndex.get()).value()).inputCount());
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<RecipeHolder<PartCuttingRecipe>> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    public boolean stillValid(Player player) {
        return PartCuttingMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockInit.ENGINEERING_WORKBENCH.get()));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.set(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipes.size();
    }

    public void slotsChanged(Container inventory) {
        ItemStack itemstack = this.inputSlot.getItem();
        this.input = itemstack.copy();
        this.setupRecipeList(inventory, itemstack);
    }

    private void setupRecipeList(Container container, ItemStack stack) {
        boolean isRecipeEmpty = this.recipes.isEmpty();
        this.recipes.clear();
        if (isRecipeEmpty) {
            this.selectedRecipeIndex.set(-1);
        }
        this.resultSlot.set(ItemStack.EMPTY);
        if (!stack.isEmpty()) {
            this.recipes = this.level.getRecipeManager().getRecipesFor(RecipeInit.PART_CUTTING_TYPE.get(), (RecipeInput)PartCuttingMenu.createRecipeInput(container), this.level);
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            RecipeHolder<PartCuttingRecipe> recipeholder = this.recipes.get(this.selectedRecipeIndex.get());
            ItemStack itemstack = ((PartCuttingRecipe)recipeholder.value()).assemble(PartCuttingMenu.createRecipeInput(this.container), (HolderLookup.Provider)this.level.registryAccess());
            if (itemstack.isItemEnabled(this.level.enabledFeatures())) {
                this.resultContainer.setRecipeUsed(recipeholder);
                this.resultSlot.set(itemstack);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public MenuType<?> getType() {
        return GuiInit.PART_CUTTING_MENU.get();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (index == 1) {
                item.onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index == 0 ? !this.moveItemStackTo(itemstack1, 2, 38, false) : (this.level.getRecipeManager().getRecipeFor(RecipeInit.PART_CUTTING_TYPE.get(), (RecipeInput)new SingleRecipeInput(itemstack1), this.level).isPresent() ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((p_40313_, p_40314_) -> this.clearContainer(player, this.container));
    }
}

