/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.gui.GuiInit;
import net.stln.magitech.item.ItemTagKeys;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.ToolMaterialRecipe;
import net.stln.magitech.recipe.input.MultiStackRecipeInput;
import net.stln.magitech.util.ComponentHelper;
import org.jetbrains.annotations.NotNull;

public class ToolRepairingMenu
extends AbstractContainerMenu {
    public static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_END = 10;
    private static final int INV_SLOT_START = 10;
    private static final int INV_SLOT_END = 37;
    private static final int USE_ROW_SLOT_START = 37;
    private static final int USE_ROW_SLOT_END = 46;
    private final ResultContainer resultSlots = new ResultContainer();
    private final Container inputSlots = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            ToolRepairingMenu.this.slotsChanged((Container)this);
        }
    };
    private final ContainerLevelAccess access;
    private final Player player;
    private final Level level;
    private boolean placingRecipe;

    public ToolRepairingMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public ToolRepairingMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(GuiInit.TOOL_REPAIRING_MENU.get(), containerId);
        this.level = playerInventory.player.level();
        this.access = access;
        this.player = playerInventory.player;
        this.addSlot(new Slot((Container)this.resultSlots, 0, 134, 49){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                stack.onCraftedBy(player.level(), player, stack.getCount());
                ToolRepairingMenu.this.resultSlots.awardUsedRecipes(player, this.getRelevantItems());
                ToolRepairingMenu.this.removeCount();
                super.onTake(player, stack);
                ToolRepairingMenu.this.slotsChanged(ToolRepairingMenu.this.inputSlots);
            }

            private List<ItemStack> getRelevantItems() {
                return ToolRepairingMenu.createRecipeInput(ToolRepairingMenu.this.inputSlots).stacks();
            }
        });
        for (int i = 0; i < 3; ++i) {
            this.addSlot(new Slot(this.inputSlots, i, 20 + i * 18, 49));
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 117 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 8 + l * 18, 175));
        }
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, Player player, Container craftSlots, ResultContainer resultSlots) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MultiStackRecipeInput recipeInput = ToolRepairingMenu.createRecipeInput(craftSlots);
            ItemStack stack = recipeInput.getItem(0).copy();
            SingleRecipeInput input = new SingleRecipeInput(recipeInput.getItem(1));
            AtomicBoolean isRepairable = new AtomicBoolean(false);
            ItemStack stack1 = stack;
            level.getRecipeManager().getRecipeFor(RecipeInit.TOOL_MATERIAL_TYPE.get(), (RecipeInput)input, level).ifPresent(holder -> {
                if (!recipeInput.getItem(2).is(ItemTagKeys.REPAIR_COMPONENT)) {
                    ToolMaterialRecipe recipe = (ToolMaterialRecipe)holder.value();
                    if (resultSlots.setRecipeUsed(level, serverPlayer, holder)) {
                        ToolMaterial toolMaterial = recipe.getToolMaterial();
                        if (ComponentHelper.getPartMaterials((DataComponentHolder)stack1).contains(toolMaterial)) {
                            for (int i = 0; i < Math.min(recipeInput.getItem(1).getCount(), recipeInput.getItem(2).getCount()); ++i) {
                                Item patt0$temp;
                                if (stack1.getDamageValue() <= 0 || !((patt0$temp = stack1.getItem()) instanceof PartToolItem)) continue;
                                PartToolItem partToolItem = (PartToolItem)patt0$temp;
                                stack1.setDamageValue(stack1.getDamageValue() - stack1.getMaxDamage() / 5);
                                partToolItem.callTestRepair(level, player, stack1.getMaxDamage() / 5, stack1);
                                partToolItem.reloadComponent(player, level, stack1);
                                isRepairable.set(true);
                            }
                        }
                    }
                }
            });
            if (!isRepairable.get()) {
                stack = ItemStack.EMPTY;
            }
            resultSlots.setItem(0, stack);
            menu.setRemoteSlot(0, stack);
            serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, menu.incrementStateId(), 0, stack));
        }
    }

    private static MultiStackRecipeInput createRecipeInput(Container container) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            stacks.add(container.getItem(i));
        }
        return new MultiStackRecipeInput(stacks);
    }

    private void removeCount() {
        int repairCount = 0;
        ItemStack stack = this.inputSlots.getItem(0).copy();
        for (int i = 0; i < Math.min(this.inputSlots.getItem(1).getCount(), this.inputSlots.getItem(2).getCount()); ++i) {
            if (stack.getDamageValue() <= 0) continue;
            stack.setDamageValue(stack.getDamageValue() - stack.getMaxDamage() / 5);
            ((PartToolItem)stack.getItem()).callOnRepair(this.level, this.player, stack.getMaxDamage() / 5, stack);
            ++repairCount;
        }
        this.inputSlots.removeItem(0, 1);
        this.inputSlots.removeItem(1, repairCount);
        this.inputSlots.removeItem(2, repairCount);
    }

    public void slotsChanged(@NotNull Container inventory) {
        if (!this.placingRecipe) {
            this.access.execute((p_344363_, p_344364_) -> ToolRepairingMenu.slotChangedCraftingGrid(this, p_344363_, this.player, this.inputSlots, this.resultSlots));
        }
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.access.execute((p_39371_, p_39372_) -> this.clearContainer(player, this.inputSlots));
    }

    public boolean stillValid(@NotNull Player player) {
        return ToolRepairingMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockInit.REPAIRING_WORKBENCH.get()));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                this.access.execute((p_39378_, p_39379_) -> itemstack1.getItem().onCraftedBy(itemstack1, p_39378_, player));
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index >= 4 && index < 40 ? !this.moveToSlots(itemstack1) && (index < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : !this.moveItemStackTo(itemstack1, 4, 31, false)) : !this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            if (index == 0) {
                player.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    private boolean moveToSlots(ItemStack itemStack) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(this.inputSlots.getItem(1));
        List optional = this.level.getRecipeManager().getAllRecipesFor(RecipeInit.TOOL_MATERIAL_TYPE.get());
        if (itemStack.getItem() instanceof PartToolItem) {
            return this.moveItemStackTo(itemStack, 1, 2, false);
        }
        if (optional.stream().anyMatch(recipe -> Arrays.stream(((Ingredient)((ToolMaterialRecipe)recipe.value()).getIngredients().get(0)).getItems()).anyMatch(stack -> stack.is(itemStack.getItem())))) {
            return this.moveItemStackTo(itemStack, 2, 3, false);
        }
        if (itemStack.getTags().anyMatch(Predicate.isEqual(ItemTagKeys.REPAIR_COMPONENT))) {
            return this.moveItemStackTo(itemStack, 3, 4, false);
        }
        return false;
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(stack, slot);
    }
}

