/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.stln.magitech.block.block_entity.ManaContainerBlockEntity;
import net.stln.magitech.item.TooltipTextItem;
import net.stln.magitech.magic.mana.ManaData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ManaChargedFluoriteItem
extends TooltipTextItem {
    public ManaChargedFluoriteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        double maxMana;
        ItemStack stack = player.getItemInHand(usedHand);
        double currentMana = ManaData.getCurrentMana(player, ManaUtil.ManaType.MANA);
        if (currentMana < (maxMana = ManaUtil.getMaxMana(player, ManaUtil.ManaType.MANA))) {
            if (!player.isCreative()) {
                stack.setCount(stack.getCount() - 1);
            }
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundInit.CRYSTAL_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(0.9f, 1.0f, 0.7f), new Vector3f(0.3f, 1.0f, 0.9f), 1.0f, 1, 0.0f), (Entity)player, 20);
            ManaUtil.setMana(player, ManaUtil.ManaType.MANA, Math.min(currentMana + 45.0, maxMana));
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        ManaContainerBlockEntity containerBlockEntity;
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ManaContainerBlockEntity && !(containerBlockEntity = (ManaContainerBlockEntity)entity).isFull()) {
            if (!player.isCreative()) {
                stack.setCount(stack.getCount() - 1);
            }
            containerBlockEntity.addMana(45);
            level.playSound(player, pos, SoundInit.CRYSTAL_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 40; ++i) {
                double x = pos.getCenter().x + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.75, (double)0.75);
                double y = pos.getCenter().y + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.75, (double)0.75);
                double z = pos.getCenter().z + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.75, (double)0.75);
                level.addParticle((ParticleOptions)new PowerupParticleEffect(new Vector3f(0.9f, 1.0f, 0.7f), new Vector3f(0.3f, 1.0f, 0.9f), 1.0f, 1, 0.0f), x, y, z, 0.0, 0.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.hint.item.magitech.mana_charged_fluorite").withColor(6332560));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

