/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.component;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.stln.magitech.Magitech;
import net.stln.magitech.item.component.MaterialComponent;
import net.stln.magitech.item.component.PartMaterialComponent;
import net.stln.magitech.item.component.SpellComponent;
import net.stln.magitech.item.component.ThreadPageComponent;
import net.stln.magitech.item.component.ToolBeltComponent;
import net.stln.magitech.item.component.UpgradeComponent;

public class ComponentInit {
    public static final DeferredRegister.DataComponents COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"magitech");
    public static final Supplier<DataComponentType<PartMaterialComponent>> PART_MATERIAL_COMPONENT = ComponentInit.register("part_material_component", PartMaterialComponent.CODEC, PartMaterialComponent.STREAM_CODEC);
    public static final Supplier<DataComponentType<MaterialComponent>> MATERIAL_COMPONENT = ComponentInit.register("material_component", MaterialComponent.CODEC, MaterialComponent.STREAM_CODEC);
    public static final Supplier<DataComponentType<SpellComponent>> SPELL_COMPONENT = ComponentInit.register("spell_component", SpellComponent.CODEC, SpellComponent.STREAM_CODEC);
    public static final Supplier<DataComponentType<ToolBeltComponent>> TOOLBELT_COMPONENT = ComponentInit.register("toolbelt_component", ToolBeltComponent.CODEC, ToolBeltComponent.STREAM_CODEC);
    public static final Supplier<DataComponentType<ThreadPageComponent>> THREAD_PAGE_COMPONENT = ComponentInit.register("thread_page_component", ThreadPageComponent.CODEC, ThreadPageComponent.STREAM_CODEC);
    public static final Supplier<DataComponentType<Integer>> TIER_COMPONENT = ComponentInit.register("tier_component", ExtraCodecs.NON_NEGATIVE_INT, ByteBufCodecs.VAR_INT);
    public static final Supplier<DataComponentType<Integer>> PROGRESSION_COMPONENT = ComponentInit.register("progression_component", ExtraCodecs.NON_NEGATIVE_INT, ByteBufCodecs.VAR_INT);
    public static final Supplier<DataComponentType<Integer>> MAX_PROGRESSION_COMPONENT = ComponentInit.register("max_progression_component", ExtraCodecs.NON_NEGATIVE_INT, ByteBufCodecs.VAR_INT);
    public static final Supplier<DataComponentType<Integer>> UPGRADE_SEED_COMPONENT = ComponentInit.register("upgrade_seed", ExtraCodecs.NON_NEGATIVE_INT, ByteBufCodecs.VAR_INT);
    public static final Supplier<DataComponentType<UpgradeComponent>> UPGRADE_COMPONENT = ComponentInit.register("upgrade_component", UpgradeComponent.CODEC, UpgradeComponent.STREAM_CODEC);
    public static final Supplier<DataComponentType<Integer>> UPGRADE_POINT_COMPONENT = ComponentInit.register("upgrade_point_component", ExtraCodecs.NON_NEGATIVE_INT, ByteBufCodecs.VAR_INT);
    public static final Supplier<DataComponentType<Boolean>> BROKEN_COMPONENT = ComponentInit.register("broken_component", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final Supplier<DataComponentType<SimpleFluidContent>> FLUID_CONTENT_COMPONENT = ComponentInit.register("fluid_content_component", SimpleFluidContent.CODEC, SimpleFluidContent.STREAM_CODEC);

    public static void registerComponents(IEventBus eventBus) {
        Magitech.LOGGER.info("Registering Data Components formagitech");
        COMPONENT_TYPES.register(eventBus);
    }

    private static <T> Supplier<DataComponentType<T>> register(String name, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        return COMPONENT_TYPES.registerComponentType(name, builder -> builder.persistent(codec).networkSynchronized(streamCodec).cacheEncoding());
    }
}

