/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.stln.magitech.item.ItemInit;
import net.stln.magitech.item.TooltipTextItem;
import net.stln.magitech.util.ComponentHelper;

public class AlchemicalFlaskItem
extends TooltipTextItem {
    public AlchemicalFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (ComponentHelper.getFluidContent((DataComponentHolder)itemstack).isEmpty()) {
            BlockHitResult blockhitresult = AlchemicalFlaskItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (blockhitresult.getType() == HitResult.Type.MISS) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (blockhitresult.getType() == HitResult.Type.BLOCK) {
                BlockPos blockpos = blockhitresult.getBlockPos();
                if (!level.mayInteract(player, blockpos)) {
                    return InteractionResultHolder.pass((Object)itemstack);
                }
                FluidState fluidState = level.getFluidState(blockpos);
                if (fluidState.is(FluidTags.WATER)) {
                    level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockpos);
                    return InteractionResultHolder.sidedSuccess((Object)this.turnBottleIntoItem(itemstack, player, ItemInit.WATER_FLASK.toStack()), (boolean)level.isClientSide());
                }
                if (!fluidState.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"item.magitech.hint.cant_pickup_fluid_from_fluid_block").withColor(0xFF8080), true);
                }
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    protected ItemStack turnBottleIntoItem(ItemStack bottleStack, Player player, ItemStack filledBottleStack) {
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return ItemUtils.createFilledResult((ItemStack)bottleStack, (Player)player, (ItemStack)filledBottleStack);
    }
}

