/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.fluid;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.stln.magitech.item.ItemInit;
import net.stln.magitech.item.TooltipTextItem;

public abstract class DrinkableFlaskItem
extends TooltipTextItem {
    public DrinkableFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        this.applyEffects(level, entityLiving, stack);
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            stack.consume(1, (LivingEntity)player);
        }
        if (player == null || !player.hasInfiniteMaterials()) {
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)ItemInit.ALCHEMICAL_FLASK.get());
            }
            if (player != null) {
                player.getInventory().add(new ItemStack((ItemLike)ItemInit.ALCHEMICAL_FLASK.get()));
            }
        }
        entityLiving.gameEvent((Holder)GameEvent.DRINK);
        return stack;
    }

    protected abstract void applyEffects(Level var1, LivingEntity var2, ItemStack var3);

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 16;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }
}

