/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.partitem;

import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.tool.ToolPart;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.util.ColorHelper;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.MathUtil;
import org.jetbrains.annotations.NotNull;

public abstract class PartItem
extends Item {
    public PartItem(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public static ToolStats getDefaultStats(@NotNull ItemStack stack) {
        return ComponentHelper.getMaterial((DataComponentHolder)stack).map(ToolMaterial::stats).orElse(ToolStats.DEFAULT);
    }

    @NotNull
    public static ToolStats getSpellCasterStats(@NotNull ItemStack stack) {
        return ComponentHelper.getMaterial((DataComponentHolder)stack).map(ToolMaterial::spellCasterStats).orElse(ToolStats.DEFAULT);
    }

    @NotNull
    public static Optional<Trait> getTrait(@NotNull ItemStack stack) {
        return ComponentHelper.getMaterial((DataComponentHolder)stack).map(ToolMaterial::trait);
    }

    public abstract ToolPart getPart();

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return (Component)ComponentHelper.getMaterial((DataComponentHolder)stack).map(ToolMaterial::getId).map(id -> Component.translatable((String)("item." + id.getNamespace() + "." + this.getPart().get()), (Object[])new Object[]{Component.translatable((String)("material.magitech." + id.getPath()))})).orElseGet(() -> super.getName(stack).copy());
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        this.addStatsHoverText(stack, tooltipComponents, Screen.hasShiftDown());
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected void setTier(ItemStack stack, ToolStats finalStats) {
        stack.update(ComponentInit.TIER_COMPONENT, (Object)finalStats.getTier(), UnaryOperator.identity());
    }

    public void addStatsHoverText(@NotNull ItemStack stack, List<Component> tooltipComponents, boolean shiftDown) {
        if (stack.has(ComponentInit.MATERIAL_COMPONENT)) {
            ToolStats finalStats = PartItem.getDefaultStats(stack);
            this.setTier(stack, finalStats);
            int tier = ComponentHelper.getTier((DataComponentHolder)stack);
            tooltipComponents.add((Component)Component.empty());
            tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.tier").append(" ").append(String.valueOf(tier)).withColor(ColorHelper.getTierColor(tier * 5)));
            if (shiftDown) {
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.attack_damage").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.ATK_STAT).floatValue(), 2))).withColor(0xFF4040)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.elemental_damage").append(": ").withColor(0xA0A0A0).append((Component)Component.translatable((String)("element.magitech." + finalStats.getElement().get())).append(" ").append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue(), 2)))).withColor(finalStats.getElement().getColor())));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.attack_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.SPD_STAT).floatValue(), 2))).withColor(4259776)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.mining_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.MIN_STAT).floatValue(), 2))).withColor(4227264)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.defense").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.DEF_STAT).floatValue(), 2))).withColor(0xA0C0C0)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.attack_range").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.RNG_STAT).floatValue(), 2))).withColor(8438015)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.sweep_range").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.SWP_STAT).floatValue(), 2))).withColor(0xFFFF80)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.durability").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.DUR_STAT).floatValue(), 2))).withColor(0xFFFFFF)));
                ToolStats spellCasterStats = PartItem.getSpellCasterStats(stack);
                tooltipComponents.add((Component)Component.empty());
                tooltipComponents.add((Component)Component.empty());
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.spell_power").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(spellCasterStats.getStats().get(ToolStats.ATK_STAT).floatValue(), 2))).withColor(0xFF4040)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.elemental_spell_power").append(": ").withColor(0xA0A0A0).append((Component)Component.translatable((String)("element.magitech." + spellCasterStats.getElement().get())).append(" ").append((Component)Component.literal((String)("x" + MathUtil.round(spellCasterStats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue(), 2)))).withColor(spellCasterStats.getElement().getColor())));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.casting_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(spellCasterStats.getStats().get(ToolStats.SPD_STAT).floatValue(), 2))).withColor(4259776)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.cooldown_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(spellCasterStats.getStats().get(ToolStats.MIN_STAT).floatValue(), 2))).withColor(4227264)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.defense").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(spellCasterStats.getStats().get(ToolStats.DEF_STAT).floatValue(), 2))).withColor(0xA0C0C0)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.projectile_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(spellCasterStats.getStats().get(ToolStats.RNG_STAT).floatValue(), 2))).withColor(8438015)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.mana_efficiency").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(spellCasterStats.getStats().get(ToolStats.SWP_STAT).floatValue(), 2))).withColor(0xFFFF80)));
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.durability").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)("x" + MathUtil.round(finalStats.getStats().get(ToolStats.DUR_STAT).floatValue(), 2))).withColor(0xFFFFFF)));
                tooltipComponents.add((Component)Component.empty());
                tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.mining_level").append(": ").withColor(0xA0A0A0).append((Component)Component.translatable((String)("attribute.magitech.mining_level." + finalStats.getMiningLevel().get())).withColor(finalStats.getMiningLevel().getColor())));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.magitech.shift").withColor(0x404040));
            }
            tooltipComponents.add((Component)Component.empty());
            PartItem.getTrait(stack).ifPresent(trait -> {
                MutableComponent component = trait.getComponent().append(" ");
                component.append("|");
                tooltipComponents.add((Component)component);
            });
        }
    }
}

