/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.register;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.Map;
import net.stln.magitech.element.Element;
import net.stln.magitech.item.tool.ToolPart;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.ToolType;
import net.stln.magitech.item.tool.material.MiningLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolMaterialRegister {
    @NotNull
    private static final Table<ToolType, Integer, ToolPart> componentPartTable;
    @NotNull
    private static final Map<ToolType, ToolStats> baseStats;
    @NotNull
    private static final Map<ToolType, ToolStats> modStats;

    @Nullable
    public static ToolPart getToolPartFromIndex(@NotNull ToolType toolType, int index) {
        return (ToolPart)((Object)componentPartTable.get((Object)toolType, (Object)index));
    }

    @Nullable
    public static ToolStats getBaseStats(@NotNull ToolType toolType) {
        return baseStats.get((Object)toolType);
    }

    @Nullable
    public static ToolStats getModStats(@NotNull ToolType toolType) {
        return modStats.get((Object)toolType);
    }

    public static void init() {
    }

    static {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.put((Object)ToolType.DAGGER, (Object)0, (Object)ToolPart.LIGHT_HANDLE);
        builder.put((Object)ToolType.DAGGER, (Object)1, (Object)ToolPart.LIGHT_BLADE);
        builder.put((Object)ToolType.DAGGER, (Object)2, (Object)ToolPart.HANDGUARD);
        builder.put((Object)ToolType.LIGHT_SWORD, (Object)0, (Object)ToolPart.LIGHT_HANDLE);
        builder.put((Object)ToolType.LIGHT_SWORD, (Object)1, (Object)ToolPart.LIGHT_BLADE);
        builder.put((Object)ToolType.LIGHT_SWORD, (Object)2, (Object)ToolPart.HANDGUARD);
        builder.put((Object)ToolType.LIGHT_SWORD, (Object)3, (Object)ToolPart.TOOL_BINDING);
        builder.put((Object)ToolType.HEAVY_SWORD, (Object)0, (Object)ToolPart.LIGHT_HANDLE);
        builder.put((Object)ToolType.HEAVY_SWORD, (Object)1, (Object)ToolPart.HEAVY_BLADE);
        builder.put((Object)ToolType.HEAVY_SWORD, (Object)2, (Object)ToolPart.TOOL_BINDING);
        builder.put((Object)ToolType.HEAVY_SWORD, (Object)3, (Object)ToolPart.HANDGUARD);
        builder.put((Object)ToolType.PICKAXE, (Object)0, (Object)ToolPart.HEAVY_HANDLE);
        builder.put((Object)ToolType.PICKAXE, (Object)1, (Object)ToolPart.SPIKE_HEAD);
        builder.put((Object)ToolType.PICKAXE, (Object)2, (Object)ToolPart.TOOL_BINDING);
        builder.put((Object)ToolType.HAMMER, (Object)0, (Object)ToolPart.HEAVY_HANDLE);
        builder.put((Object)ToolType.HAMMER, (Object)1, (Object)ToolPart.STRIKE_HEAD);
        builder.put((Object)ToolType.HAMMER, (Object)2, (Object)ToolPart.PLATE);
        builder.put((Object)ToolType.HAMMER, (Object)3, (Object)ToolPart.TOOL_BINDING);
        builder.put((Object)ToolType.AXE, (Object)0, (Object)ToolPart.HEAVY_HANDLE);
        builder.put((Object)ToolType.AXE, (Object)1, (Object)ToolPart.LIGHT_BLADE);
        builder.put((Object)ToolType.AXE, (Object)2, (Object)ToolPart.STRIKE_HEAD);
        builder.put((Object)ToolType.AXE, (Object)3, (Object)ToolPart.TOOL_BINDING);
        builder.put((Object)ToolType.SHOVEL, (Object)0, (Object)ToolPart.HEAVY_HANDLE);
        builder.put((Object)ToolType.SHOVEL, (Object)1, (Object)ToolPart.LIGHT_BLADE);
        builder.put((Object)ToolType.SHOVEL, (Object)2, (Object)ToolPart.PLATE);
        builder.put((Object)ToolType.SHOVEL, (Object)3, (Object)ToolPart.TOOL_BINDING);
        builder.put((Object)ToolType.SCYTHE, (Object)0, (Object)ToolPart.REINFORCED_STICK);
        builder.put((Object)ToolType.SCYTHE, (Object)1, (Object)ToolPart.HEAVY_HANDLE);
        builder.put((Object)ToolType.SCYTHE, (Object)2, (Object)ToolPart.HEAVY_BLADE);
        builder.put((Object)ToolType.SCYTHE, (Object)3, (Object)ToolPart.TOOL_BINDING);
        builder.put((Object)ToolType.WAND, (Object)0, (Object)ToolPart.CATALYST);
        builder.put((Object)ToolType.WAND, (Object)1, (Object)ToolPart.LIGHT_HANDLE);
        builder.put((Object)ToolType.WAND, (Object)2, (Object)ToolPart.CONDUCTOR);
        builder.put((Object)ToolType.WAND, (Object)3, (Object)ToolPart.TOOL_BINDING);
        componentPartTable = builder.build();
        ImmutableMap.Builder baseStatsBuilder = ImmutableMap.builder();
        baseStatsBuilder.put((Object)ToolType.DAGGER, (Object)new ToolStats(2.0f, 3.0f, 3.0f, 5.0f, 2.0f, 2.5f, 1.0f, 288.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStatsBuilder.put((Object)ToolType.LIGHT_SWORD, (Object)new ToolStats(4.0f, 4.0f, 1.6f, 5.0f, 2.0f, 3.0f, 3.0f, 361.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStatsBuilder.put((Object)ToolType.HEAVY_SWORD, (Object)new ToolStats(6.0f, 4.0f, 0.8f, 5.0f, 6.0f, 3.0f, 3.0f, 536.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStatsBuilder.put((Object)ToolType.PICKAXE, (Object)new ToolStats(2.0f, 1.0f, 2.4f, 5.0f, 1.0f, 2.5f, 1.5f, 319.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStatsBuilder.put((Object)ToolType.HAMMER, (Object)new ToolStats(8.0f, 7.0f, 0.6f, 5.0f, 4.0f, 2.5f, 2.0f, 1013.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStatsBuilder.put((Object)ToolType.AXE, (Object)new ToolStats(5.0f, 3.0f, 1.0f, 5.0f, 5.0f, 3.5f, 3.0f, 325.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStatsBuilder.put((Object)ToolType.SHOVEL, (Object)new ToolStats(3.0f, 3.0f, 2.0f, 5.0f, 6.0f, 3.0f, 4.0f, 401.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStatsBuilder.put((Object)ToolType.SCYTHE, (Object)new ToolStats(3.0f, 6.0f, 0.7f, 5.0f, 2.0f, 4.5f, 6.0f, 594.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStatsBuilder.put((Object)ToolType.WAND, (Object)new ToolStats(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.2f, 378.0f, Element.NONE, MiningLevel.NONE, 0));
        baseStats = baseStatsBuilder.build();
        ImmutableMap.Builder modStatsBuilder = ImmutableMap.builder();
        modStatsBuilder.put((Object)ToolType.WAND, (Object)new ToolStats(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.2f, 378.0f, Element.NONE, MiningLevel.NONE, 0));
        modStats = modStatsBuilder.build();
    }
}

